"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observableIntoStream = observableIntoStream;
var _stream = require("stream");
var _conversation_complete = require("../../../common/conversation_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function observableIntoStream(source) {
  const stream = new _stream.PassThrough();
  source.subscribe({
    next: event => {
      stream.write(JSON.stringify(event) + '\n');
    },
    error: error => {
      const errorEvent = {
        error: {
          message: error.message,
          stack: error.stack,
          code: (0, _conversation_complete.isChatCompletionError)(error) ? error.code : undefined,
          meta: error.meta
        },
        type: _conversation_complete.StreamingChatResponseEventType.ChatCompletionError
      };
      stream.write(JSON.stringify(errorEvent) + '\n');
      stream.end();
    },
    complete: () => {
      stream.end();
    }
  });
  return stream;
}