"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OBSERVABILITY_AGENT_TOOL_IDS = void 0;
exports.registerTools = registerTools;
var _onechatCommon = require("@kbn/onechat-common");
var _get_data_sources = require("./get_data_sources/get_data_sources");
var _search_knowledge_base = require("./search_knowledge_base/search_knowledge_base");
var _run_log_rate_analysis = require("./run_log_rate_analysis/run_log_rate_analysis");
var _get_anomaly_detection_jobs = require("./get_anomaly_detection_jobs/get_anomaly_detection_jobs");
var _get_alerts = require("./get_alerts/get_alerts");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLATFORM_TOOL_IDS = [_onechatCommon.platformCoreTools.search, _onechatCommon.platformCoreTools.listIndices, _onechatCommon.platformCoreTools.getIndexMapping, _onechatCommon.platformCoreTools.getDocumentById];
const OBSERVABILITY_TOOL_IDS = [_get_data_sources.OBSERVABILITY_GET_DATA_SOURCES_TOOL_ID, _search_knowledge_base.OBSERVABILITY_SEARCH_KNOWLEDGE_BASE_TOOL_ID, _run_log_rate_analysis.OBSERVABILITY_RUN_LOG_RATE_ANALYSIS_TOOL_ID, _get_anomaly_detection_jobs.OBSERVABILITY_GET_ANOMALY_DETECTION_JOBS_TOOL_ID, _get_alerts.OBSERVABILITY_GET_ALERTS_TOOL_ID];

// registered in the APM plugin
const APM_TOOL_IDS = [_constants.OBSERVABILITY_GET_SERVICES_TOOL_ID, _constants.OBSERVABILITY_GET_DOWNSTREAM_DEPENDENCIES_TOOL_ID];
const OBSERVABILITY_AGENT_TOOL_IDS = exports.OBSERVABILITY_AGENT_TOOL_IDS = [...PLATFORM_TOOL_IDS, ...OBSERVABILITY_TOOL_IDS, ...APM_TOOL_IDS];
async function registerTools({
  core,
  plugins,
  logger
}) {
  const observabilityTools = [(0, _get_data_sources.createGetDataSourcesTool)({
    core,
    plugins,
    logger
  }), (0, _search_knowledge_base.createSearchKnowledgeBaseTool)({
    core,
    logger
  }), (0, _run_log_rate_analysis.createRunLogRateAnalysisTool)({
    logger
  }), (0, _get_anomaly_detection_jobs.createGetAnomalyDetectionJobsTool)({
    core,
    plugins,
    logger
  }), (0, _get_alerts.createGetAlertsTool)({
    core,
    logger
  })];
  for (const tool of observabilityTools) {
    plugins.onechat.tools.register(tool);
  }
}