"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _util = require("./util");
var _anomaly_source_field = require("./anomaly_source_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/maps/layer_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line @typescript-eslint/no-empty-interface

class LayerSelector extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "onSelect", selectedOptions => {
      const typicalActual = selectedOptions[0].value;
      if (this._isMounted) {
        this.setState({
          typicalActual
        });
        this.props.onChange(typicalActual);
      }
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    const options = [{
      value: this.props.typicalActual,
      label: this.props.typicalActual
    }];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.ml.maps.typicalActualLabel', {
        defaultMessage: 'Type'
      }),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      singleSelection: true,
      onChange: this.onSelect,
      options: [{
        value: _util.ML_ANOMALY_LAYERS.ACTUAL,
        label: _anomaly_source_field.ACTUAL_LABEL
      }, {
        value: _util.ML_ANOMALY_LAYERS.TYPICAL,
        label: _anomaly_source_field.TYPICAL_LABEL
      }, {
        value: _util.ML_ANOMALY_LAYERS.TYPICAL_TO_ACTUAL,
        label: _anomaly_source_field.TYPICAL_TO_ACTUAL
      }],
      selectedOptions: options,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }));
  }
}
exports.LayerSelector = LayerSelector;