"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateJob = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _utils = require("../../../../application/jobs/new_job/job_from_pattern_analysis/utils");
var _general = require("../../../../application/jobs/new_job/common/job_creator/util/general");
var _new_job_capabilities_service = require("../../../../application/services/new_job_capabilities/new_job_capabilities_service");
var _job_from_pattern_analysis = require("../../../../application/jobs/new_job/job_from_pattern_analysis");
var _context = require("../../common/context");
var _job_details = require("../../common/job_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/job_creation/aiops/flyout/create_job.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateJob = ({
  dataView,
  field,
  query,
  timeRange
}) => {
  const {
    services: {
      data,
      share,
      uiSettings,
      mlServices: {
        mlApi
      }
    }
  } = (0, _context.useMlFromLensKibanaContext)();
  const [categorizationType, setCategorizationType] = (0, _react.useState)(_job_from_pattern_analysis.CATEGORIZATION_TYPE.COUNT);
  const [enablePerPartitionCategorization, setEnablePerPartitionCategorization] = (0, _react.useState)(false);
  const [stopOnWarn, setStopOnWarn] = (0, _react.useState)(false);
  const [categoryFieldOptions, setCategoryFieldsOptions] = (0, _react.useState)([]);
  const [selectedPartitionFieldOptions, setSelectedPartitionFieldOptions] = (0, _react.useState)([]);
  const [formComplete, setFormComplete] = (0, _react.useState)(undefined);
  const toggleEnablePerPartitionCategorization = (0, _react.useCallback)(() => setEnablePerPartitionCategorization(!enablePerPartitionCategorization), [enablePerPartitionCategorization]);
  const toggleStopOnWarn = (0, _react.useCallback)(() => setStopOnWarn(!stopOnWarn), [stopOnWarn]);
  (0, _react.useMemo)(() => {
    const newJobCapsService = new _new_job_capabilities_service.NewJobCapsService(mlApi);
    newJobCapsService.initializeFromDataVIew(dataView).then(() => {
      const options = [...(0, _general.createFieldOptions)(newJobCapsService.categoryFields, [])].map(o => ({
        ...o
      }));
      setCategoryFieldsOptions(options);
    });
  }, [dataView, mlApi]);
  const quickJobCreator = (0, _react.useMemo)(() => new _job_from_pattern_analysis.QuickCategorizationJobCreator(data.dataViews, uiSettings, data.query.timefilter.timefilter, share, data, mlApi), [share, data, mlApi, uiSettings]);
  function createADJobInWizard() {
    var _dataView$getFieldByN;
    const partitionField = selectedPartitionFieldOptions.length ? (_dataView$getFieldByN = dataView.getFieldByName(selectedPartitionFieldOptions[0].label)) !== null && _dataView$getFieldByN !== void 0 ? _dataView$getFieldByN : null : null;
    (0, _utils.redirectToADJobWizards)(categorizationType, dataView, field, partitionField, stopOnWarn, query, timeRange, share);
  }
  (0, _react.useEffect)(() => {
    setSelectedPartitionFieldOptions([]);
    setStopOnWarn(false);
  }, [enablePerPartitionCategorization]);
  (0, _react.useEffect)(() => {
    setFormComplete(enablePerPartitionCategorization === false || selectedPartitionFieldOptions.length > 0);
  }, [enablePerPartitionCategorization, selectedPartitionFieldOptions]);
  async function createADJob({
    jobId,
    bucketSpan,
    startJob,
    runInRealTime
  }) {
    var _dataView$getFieldByN2;
    const partitionField = selectedPartitionFieldOptions.length ? (_dataView$getFieldByN2 = dataView.getFieldByName(selectedPartitionFieldOptions[0].label)) !== null && _dataView$getFieldByN2 !== void 0 ? _dataView$getFieldByN2 : null : null;
    const result = await quickJobCreator.createAndSaveJob(categorizationType, jobId, bucketSpan, dataView, field, partitionField, stopOnWarn, query, timeRange, startJob, runInRealTime);
    return result;
  }
  return /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
    createADJob: createADJob,
    createADJobInWizard: createADJobInWizard,
    timeRange: timeRange,
    layer: undefined,
    layerIndex: 0,
    outerFormComplete: formComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: 'count',
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Count",
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.count.title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Look for anomalies in the event rate of a category.",
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.count.description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.count.description2",
      defaultMessage: "Recommended for categorizing all messages.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 15
      }
    })),
    checked: categorizationType === _job_from_pattern_analysis.CATEGORIZATION_TYPE.COUNT,
    onChange: () => setCategorizationType(_job_from_pattern_analysis.CATEGORIZATION_TYPE.COUNT),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: 'highCount',
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "High count",
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.highCount.title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Look for unusually high counts of a category in the event rate.",
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.highCount.description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.highCount.description2",
      defaultMessage: "Recommended for categorizing error messages.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 15
      }
    })),
    checked: categorizationType === _job_from_pattern_analysis.CATEGORIZATION_TYPE.HIGH_COUNT,
    onChange: () => setCategorizationType(_job_from_pattern_analysis.CATEGORIZATION_TYPE.HIGH_COUNT),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: 'rare',
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Rare",
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.rare.title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Look for categories that occur rarely in time.",
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.rare.description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 15
      }
    })),
    checked: categorizationType === _job_from_pattern_analysis.CATEGORIZATION_TYPE.RARE,
    onChange: () => setCategorizationType(_job_from_pattern_analysis.CATEGORIZATION_TYPE.RARE),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "categorizationPerPartitionSwitch",
    disabled: false,
    checked: enablePerPartitionCategorization,
    onChange: toggleEnablePerPartitionCategorization,
    "data-test-subj": "mlNewJobFromPatternAnalysisFlyoutSwitchCategorizationPerPartition",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.perPartitionCategorizationSwitchLabel",
      defaultMessage: "Enable per-partition categorization",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }), enablePerPartitionCategorization ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.categorizationPerPartitionField.infoCallout",
      defaultMessage: "Determine categories independently for each value of the partition field.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.categorizationPerPartitionFieldLabel",
      defaultMessage: "Partition field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: categoryFieldOptions,
    selectedOptions: selectedPartitionFieldOptions,
    onChange: setSelectedPartitionFieldOptions,
    isClearable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "categorizationPerPartitionSwitch",
    disabled: false,
    checked: stopOnWarn,
    onChange: toggleStopOnWarn,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.stopOnWarnSwitchLabel",
      defaultMessage: "Stop on warn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 9
    }
  })));
};
exports.CreateJob = CreateJob;