"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardServiceProvider = dashboardServiceProvider;
exports.useDashboardService = useDashboardService;
var _react = require("react");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _kibana = require("../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function dashboardServiceProvider(dashboardService, share) {
  return {
    /**
     * Fetches dashboards
     */
    async fetchDashboards(query) {
      const findDashboardsService = await dashboardService.findDashboardsService();
      const responses = await findDashboardsService.search({
        search: query !== null && query !== void 0 ? query : '',
        per_page: 1000
      });
      return responses.dashboards;
    },
    /**
     * Fetch dashboards by id
     */
    async fetchDashboardsById(ids) {
      const findDashboardsService = await dashboardService.findDashboardsService();
      const responses = await findDashboardsService.findByIds(ids);
      const existingDashboards = responses.filter(({
        status
      }) => status === 'success');
      return existingDashboards;
    },
    /**
     * Generates dashboard url
     */
    async getDashboardUrl(dashboardId, viewMode = 'edit') {
      var _share$url$locators$g;
      return await ((_share$url$locators$g = share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR)) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.getUrl({
        dashboardId,
        viewMode: 'edit',
        useHash: false
      }));
    }
  };
}

/**
 * Hook to use {@link DashboardService} in react components
 */
function useDashboardService() {
  const {
    services: {
      dashboard,
      share
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => dashboardServiceProvider(dashboard, share), [dashboard, share]);
}