"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestTrainedModelFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _test_trained_model_content = require("./test_trained_model_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/test_models/test_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TestTrainedModelFlyout = ({
  model,
  onClose
}) => {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "aria-labelledby": flyoutTitleId,
    maxWidth: 600,
    onClose: onClose,
    "data-test-subj": "mlTestModelsFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.headerLabel",
    defaultMessage: "Test trained model",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, model.model_id))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_test_trained_model_content.TestTrainedModelContent, {
    model: model,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  })));
};
exports.TestTrainedModelFlyout = TestTrainedModelFlyout;