"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsListUI = exports.JobsList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _mlDateUtils = require("@kbn/ml-date-utils");
var _public = require("@kbn/kibana-react-plugin/public");
var _string_utils = require("../../../../util/string_utils");
var _job_message_icon = require("../../../../components/job_message_icon");
var _job_actions = require("../job_actions");
var _job_description = require("./job_description");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _job_id_link = require("./job_id_link");
var _jobs_utils = require("../../../jobs_utils");
var _ml_saved_objects_spaces_list = require("../../../../components/ml_saved_objects_spaces_list");
var _saved_objects = require("../../../../../../common/types/saved_objects");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/jobs_list/jobs_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGE_SIZE_OPTIONS = [10, 25, 50];
class JobsListUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onTableChange", ({
      page = {},
      sort = {}
    }) => {
      const {
        index: pageIndex,
        size: pageSize
      } = page;
      const {
        field: sortField,
        direction: sortDirection
      } = sort;
      this.props.onJobsViewStateUpdate({
        pageIndex,
        pageSize,
        sortField,
        sortDirection
      });
    });
    (0, _defineProperty2.default)(this, "toggleRow", item => {
      this.props.toggleRow(item.id);
    });
    this.state = {
      jobsSummaryList: props.jobsSummaryList,
      itemIdToExpandedRowMap: {}
    };
    this.mlApi = props.kibana.services.mlServices.mlApi;
  }
  static getDerivedStateFromProps(props) {
    const itemIdToExpandedRowMap = props.itemIdToExpandedRowMap;
    const jobsSummaryList = props.jobsSummaryList;
    return {
      itemIdToExpandedRowMap,
      jobsSummaryList
    };
  }
  getJobIdLink(id) {
    // Don't allow link to job if ML is not enabled in current space
    if (this.props.isMlEnabledInSpace === false) {
      return id;
    }
    return /*#__PURE__*/_react.default.createElement(_job_id_link.AnomalyDetectionJobIdLink, {
      key: id,
      id: id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 12
      }
    });
  }
  getPageOfJobs(index, size, sortField, sortDirection) {
    let list = this.state.jobsSummaryList;
    list = (0, _lodash.sortBy)(this.state.jobsSummaryList, item => item[sortField]);
    list = sortDirection === 'asc' ? list : list.reverse();
    const listLength = list.length;
    let pageStart = index * size;
    if (pageStart >= listLength && listLength !== 0) {
      // if the page start is larger than the number of items due to
      // filters being applied or jobs being deleted, calculate a new page start
      pageStart = Math.floor((listLength - 1) / size) * size;
      // set the state out of the render cycle
      setTimeout(() => {
        this.props.onJobsViewStateUpdate({
          pageIndex: pageStart / size
        });
      }, 0);
    }
    return {
      pageOfItems: list.slice(pageStart, pageStart + size),
      totalItemCount: listLength
    };
  }
  render() {
    const {
      loading
    } = this.props;
    const selectionControls = {
      selectable: job => job.blocked === undefined,
      selectableMessage: (selectable, rowItem) => selectable === false ? _i18n.i18n.translate('xpack.ml.jobsList.cannotSelectRowForJobMessage', {
        defaultMessage: 'Cannot select job ID {jobId}',
        values: {
          jobId: rowItem.id
        }
      }) : _i18n.i18n.translate('xpack.ml.jobsList.selectRowForJobMessage', {
        defaultMessage: 'Select the row for job ID {jobId}',
        values: {
          jobId: rowItem.id
        }
      }),
      onSelectionChange: this.props.selectJobChange
    };
    // Adding 'width' props to columns for use in the Kibana management jobs list table
    // The version of the table used in ML > Job Management depends on many EUI class overrides that set the width explicitly.
    // The ML > Job Management table won't change as the overwritten class styles take precedence, though these values may need to
    // be updated if we move to always using props for width.
    const columns = [{
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.showDetailsColumn.screenReaderDescription",
        defaultMessage: "This column contains clickable controls for showing more details on each job",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 15
        }
      }))),
      'data-test-subj': 'mlJobListColumnExpand',
      render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => this.toggleRow(item),
        iconType: this.state.itemIdToExpandedRowMap[item.id] ? 'arrowDown' : 'arrowRight',
        "aria-label": this.state.itemIdToExpandedRowMap[item.id] ? _i18n.i18n.translate('xpack.ml.jobsList.collapseJobDetailsAriaLabel', {
          defaultMessage: 'Hide details for {itemId}',
          values: {
            itemId: item.id
          }
        }) : _i18n.i18n.translate('xpack.ml.jobsList.expandJobDetailsAriaLabel', {
          defaultMessage: 'Show details for {itemId}',
          values: {
            itemId: item.id
          }
        }),
        "data-row-id": item.id,
        "data-test-subj": "mlJobListRowDetailsToggle",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 11
        }
      }),
      width: '3%'
    }, {
      field: 'id',
      'data-test-subj': 'mlJobListColumnId',
      name: _i18n.i18n.translate('xpack.ml.jobsList.idLabel', {
        defaultMessage: 'ID'
      }),
      sortable: true,
      truncateText: false,
      width: '15%',
      render: (id, item) => {
        if (!(0, _jobs_utils.isManagedJob)(item)) return id;
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 185,
            columnNumber: 15
          }
        }, id, " \xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: _i18n.i18n.translate('xpack.ml.jobsList.managedBadgeTooltip', {
            defaultMessage: 'This job is preconfigured and managed by Elastic; other parts of the product might have might have dependencies on its behavior.'
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 187,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          tabIndex: 0,
          color: "hollow",
          "data-test-subj": "mlJobListRowManagedLabel",
          size: "xs",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 193,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.ml.jobsList.managedBadgeLabel', {
          defaultMessage: 'Managed'
        })))));
      }
    }, {
      'data-test-subj': 'mlJobListColumnIcons',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.iconsColumn.screenReaderDescription",
        defaultMessage: "This column displays an alert icon when the job has alert rules, or a status icon when there are warnings or errors in the past 24 hours",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 15
        }
      }))),
      width: '50px',
      render: row => {
        var _row$alertingRules;
        const showAlertIcon = Array.isArray(row.alertingRules) && row.alertingRules.length > 0;
        const showAuditIcon = Boolean(row.auditMessage);
        if (!showAlertIcon && !showAuditIcon) return null;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          responsive: false,
          justifyContent: "flexEnd",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 227,
            columnNumber: 13
          }
        }, showAlertIcon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 229,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          position: "bottom",
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.jobsList.alertingRules.tooltipContent",
            defaultMessage: "Job has {rulesCount} associated alert {rulesCount, plural, one {rule} other {rules}}",
            values: {
              rulesCount: (_row$alertingRules = row.alertingRules) === null || _row$alertingRules === void 0 ? void 0 : _row$alertingRules.length
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 233,
              columnNumber: 23
            }
          }),
          type: "bell",
          "data-test-subj": "mlJobListAlertRulesIcon",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 230,
            columnNumber: 19
          }
        })), showAuditIcon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 245,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_job_message_icon.JobIcon, {
          message: row.auditMessage,
          showTooltip: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 246,
            columnNumber: 19
          }
        })));
      }
    }, {
      name: _i18n.i18n.translate('xpack.ml.jobsList.descriptionLabel', {
        defaultMessage: 'Description'
      }),
      sortable: true,
      field: 'description',
      'data-test-subj': 'mlJobListColumnDescription',
      render: (description, item) => /*#__PURE__*/_react.default.createElement(_job_description.JobDescription, {
        job: item,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 40
        }
      }),
      textOnly: true,
      width: '20%'
    }, {
      field: 'processed_record_count',
      'data-test-subj': 'mlJobListColumnRecordCount',
      name: _i18n.i18n.translate('xpack.ml.jobsList.processedRecordsLabel', {
        defaultMessage: 'Processed records'
      }),
      sortable: true,
      truncateText: false,
      dataType: 'number',
      render: count => (0, _string_utils.toLocaleString)(count),
      width: '10%'
    }, {
      field: 'memory_status',
      'data-test-subj': 'mlJobListColumnMemoryStatus',
      name: _i18n.i18n.translate('xpack.ml.jobsList.memoryStatusLabel', {
        defaultMessage: 'Memory status'
      }),
      sortable: true,
      truncateText: false,
      width: '5%'
    }, {
      field: 'jobState',
      'data-test-subj': 'mlJobListColumnJobState',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobStateLabel', {
        defaultMessage: 'Job state'
      }),
      sortable: true,
      truncateText: false,
      width: '8%'
    }, {
      field: 'datafeedState',
      'data-test-subj': 'mlJobListColumnDatafeedState',
      name: _i18n.i18n.translate('xpack.ml.jobsList.datafeedStateLabel', {
        defaultMessage: 'Datafeed state'
      }),
      sortable: true,
      truncateText: false,
      width: '8%'
    }, {
      name: _i18n.i18n.translate('xpack.ml.jobsList.latestTimestampLabel', {
        defaultMessage: 'Latest timestamp'
      }),
      truncateText: false,
      field: 'latestTimestampSortValue',
      'data-test-subj': 'mlJobListColumnLatestTimestamp',
      sortable: true,
      render: (time, item) => item.latestTimestampMs === undefined ? '' : (0, _moment.default)(item.latestTimestampMs).format(_mlDateUtils.TIME_FORMAT),
      textOnly: true,
      width: '15%'
    }, {
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 323,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 324,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.jobActionsColumn.screenReaderDescription",
        defaultMessage: "This column contains extra actions in a menu that can be performed on each job",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 325,
          columnNumber: 15
        }
      }))),
      render: item => /*#__PURE__*/_react.default.createElement(_job_actions.ResultLinks, {
        jobs: [item],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 332,
          columnNumber: 27
        }
      }),
      width: '64px'
    }, ...(this.props.kibana.services.spaces ? [{
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobActionsColumn.spaces', {
        defaultMessage: 'Spaces'
      }),
      'data-test-subj': 'mlTableColumnSpaces',
      truncateText: true,
      align: 'right',
      width: '10%',
      render: item => {
        var _this$props$kibana$se, _this$props$kibana$se2, _this$props$kibana$se3;
        return /*#__PURE__*/_react.default.createElement(_ml_saved_objects_spaces_list.MLSavedObjectsSpacesList, {
          disabled: !((_this$props$kibana$se = this.props.kibana.services.application) !== null && _this$props$kibana$se !== void 0 && (_this$props$kibana$se2 = _this$props$kibana$se.capabilities) !== null && _this$props$kibana$se2 !== void 0 && (_this$props$kibana$se3 = _this$props$kibana$se2.savedObjectsManagement) !== null && _this$props$kibana$se3 !== void 0 && _this$props$kibana$se3.shareIntoSpace),
          spacesApi: this.props.kibana.services.spaces,
          spaceIds: item.spaces,
          id: item.id,
          mlSavedObjectType: _saved_objects.ANOMALY_DETECTOR_SAVED_OBJECT_TYPE,
          refresh: this.props.refreshJobs,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 347,
            columnNumber: 19
          }
        });
      }
    }] : []), {
      name: _i18n.i18n.translate('xpack.ml.jobsList.actionsLabel', {
        defaultMessage: 'Actions'
      }),
      actions: (0, _job_actions.actionsMenuContent)(this.props.kibana.services.notifications.toasts, this.props.kibana.services.share, this.mlApi, this.props.showEditJobFlyout, this.props.showDatafeedChartFlyout, this.props.showDeleteJobModal, this.props.showResetJobModal, this.props.showStartDatafeedModal, this.props.showCloseJobsConfirmModal, this.props.showStopDatafeedsConfirmModal, this.props.refreshJobs, this.props.showCreateAlertFlyout),
      width: '5%'
    }];
    const {
      pageIndex,
      pageSize,
      sortField,
      sortDirection
    } = this.props.jobsViewState;
    const {
      pageOfItems,
      totalItemCount
    } = this.getPageOfJobs(pageIndex, pageSize, sortField, sortDirection);
    const pagination = {
      pageIndex,
      pageSize,
      totalItemCount,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    };
    const sorting = {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    };
    const selectedJobsClass = this.props.selectedJobsCount ? 'jobs-selected' : '';
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      "data-test-subj": loading ? 'mlJobListTable loading' : 'mlJobListTable loaded',
      loading: loading === true,
      noItemsMessage: loading ? _i18n.i18n.translate('xpack.ml.jobsList.loadingJobsLabel', {
        defaultMessage: 'Loading jobs…'
      }) : _i18n.i18n.translate('xpack.ml.jobsList.noJobsFoundLabel', {
        defaultMessage: 'No jobs found'
      }),
      itemId: "id",
      className: `jobs-list-table ${selectedJobsClass}`,
      items: pageOfItems,
      columns: columns,
      pagination: pagination,
      onChange: this.onTableChange,
      selection: selectionControls,
      itemIdToExpandedRowMap: this.state.itemIdToExpandedRowMap,
      sorting: sorting,
      rowProps: item => ({
        'data-test-subj': `mlJobListRow row-${item.id}`
      }),
      css: {
        '.euiTableRow-isExpandedRow .euiTableCellContent': {
          animation: 'none'
        }
      },
      rowHeader: "id",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 413,
        columnNumber: 9
      }
    }));
  }
}
exports.JobsListUI = JobsListUI;
JobsListUI.propTypes = {
  jobsSummaryList: _propTypes.default.array.isRequired,
  fullJobsList: _propTypes.default.object.isRequired,
  isMlEnabledInSpace: _propTypes.default.bool,
  itemIdToExpandedRowMap: _propTypes.default.object.isRequired,
  toggleRow: _propTypes.default.func.isRequired,
  selectJobChange: _propTypes.default.func.isRequired,
  showEditJobFlyout: _propTypes.default.func,
  showDatafeedChartFlyout: _propTypes.default.func,
  showDeleteJobModal: _propTypes.default.func,
  showStartDatafeedModal: _propTypes.default.func,
  showCloseJobsConfirmModal: _propTypes.default.func,
  showCreateAlertFlyout: _propTypes.default.func,
  showStopDatafeedsConfirmModal: _propTypes.default.func,
  refreshJobs: _propTypes.default.func,
  selectedJobsCount: _propTypes.default.number.isRequired,
  loading: _propTypes.default.bool,
  jobsViewState: _propTypes.default.object,
  onJobsViewStateUpdate: _propTypes.default.func
};
JobsListUI.defaultProps = {
  isMlEnabledInSpace: true,
  loading: false
};
const JobsList = exports.JobsList = (0, _public.withKibana)(JobsListUI);