"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapCenterSchema = exports.mapAttributesSchema = exports.adhocDataViewSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQueryServer = require("@kbn/es-query-server");
var _dataServiceServer = require("@kbn/data-service-server");
var _layer_schemas = require("../layer_schemas");
var _settings_schema = require("./settings_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapCenterSchema = exports.mapCenterSchema = _configSchema.schema.object({
  lat: _configSchema.schema.number(),
  lon: _configSchema.schema.number()
});
const adhocDataViewSchema = exports.adhocDataViewSchema = _configSchema.schema.object({
  allowHidden: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  id: _configSchema.schema.string(),
  name: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Human readable name used to differentiate the data view.'
    }
  })),
  timeFieldName: _configSchema.schema.maybe(_configSchema.schema.string()),
  title: _configSchema.schema.string({
    meta: {
      description: 'Contrary to its name, this property sets the index pattern of the data view. (e.g. `logs-*,metrics-*`)'
    }
  })
});
const mapAttributesSchema = exports.mapAttributesSchema = _configSchema.schema.object({
  adHocDataViews: _configSchema.schema.maybe(_configSchema.schema.arrayOf(adhocDataViewSchema)),
  center: _configSchema.schema.maybe(mapCenterSchema),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  filters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_esQueryServer.storedFilterSchema)),
  isLayerTOCOpen: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: true,
    meta: {
      description: 'Set to false to display map with collapsed legend.'
    }
  })),
  layers: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_layer_schemas.layersSchema, {
    defaultValue: [],
    meta: {
      description: 'Map layers. When not provided, map contain configured base map.'
    }
  })),
  openTOCDetails: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'Add layer id to array to expand layer details in legend'
    }
  }))),
  query: _configSchema.schema.maybe(_esQueryServer.querySchema),
  refreshInterval: _configSchema.schema.maybe(_dataServiceServer.refreshIntervalSchema),
  settings: _configSchema.schema.maybe(_settings_schema.settingsSchema),
  timeFilters: _configSchema.schema.maybe(_esQueryServer.timeRangeSchema),
  title: _configSchema.schema.string(),
  zoom: _configSchema.schema.maybe(_configSchema.schema.number({
    max: 24,
    min: 0
  }))
}, {
  unknowns: 'forbid'
});