"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUiActions = registerUiActions;
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _constants = require("./filter_by_map_extent/constants");
var _constants2 = require("./synchronize_movement/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function registerUiActions(core, plugins) {
  if (core.application.capabilities.maps_v2.show) {
    plugins.uiActions.addTriggerActionAsync(_public2.VISUALIZE_GEO_FIELD_TRIGGER, _public2.ACTION_VISUALIZE_GEO_FIELD, async () => {
      const {
        visualizeGeoFieldAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./visualize_geo_field_action')));
      return visualizeGeoFieldAction;
    });
  }
  plugins.uiActions.registerActionAsync('addMapPanelAction', async () => {
    const {
      getAddMapPanelAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_map_panel_action')));
    return getAddMapPanelAction(plugins);
  });
  plugins.uiActions.attachAction(_public2.ADD_PANEL_TRIGGER, 'addMapPanelAction');
  if (plugins.uiActions.hasTrigger('ADD_CANVAS_ELEMENT_TRIGGER')) {
    // Because Canvas is not enabled in Serverless, this trigger might not be registered - only attach
    // the create action if the Canvas-specific trigger does indeed exist.
    plugins.uiActions.attachAction('ADD_CANVAS_ELEMENT_TRIGGER', 'addMapPanelAction');
  }
  plugins.uiActions.addTriggerActionAsync(_public.CONTEXT_MENU_TRIGGER, _constants.FILTER_BY_MAP_EXTENT, async () => {
    const {
      filterByMapExtentAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./context_menu_actions_module')));
    return filterByMapExtentAction;
  });
  plugins.uiActions.addTriggerActionAsync(_public.CONTEXT_MENU_TRIGGER, _constants2.SYNCHRONIZE_MOVEMENT_ACTION, async () => {
    const {
      synchronizeMovementAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./context_menu_actions_module')));
    return synchronizeMovementAction;
  });
}