"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _security_index_pattern_utils = require("./security_index_pattern_utils");
var _i18n_getters = require("../../../../../../common/i18n_getters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/solution_layers/security/index_pattern_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class IndexPatternSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      hasLoaded: false,
      options: []
    });
    (0, _defineProperty2.default)(this, "_onChange", event => {
      const targetOption = this.state.options.find(({
        value,
        text
      }) => {
        return event.target.value === value;
      });
      if (event.target.value === '' || !targetOption) {
        this.props.onChange(null);
        return;
      }
      this.props.onChange({
        // @ts-expect-error - avoid wrong "Property does not exist on type 'never'." compile error
        id: targetOption.value,
        // @ts-expect-error - avoid wrong "Property does not exist on type 'never'." compile error
        title: targetOption.text
      });
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadOptions();
  }
  async _loadOptions() {
    const indexPatterns = await (0, _security_index_pattern_utils.getSecurityIndexPatterns)();
    if (!this._isMounted) {
      return;
    }
    this.setState({
      hasLoaded: true,
      options: [{
        value: '',
        text: ''
      }, ...indexPatterns.map(({
        id,
        title
      }) => {
        return {
          value: id,
          text: title
        };
      })]
    });
  }
  render() {
    if (!this.state.hasLoaded) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: (0, _i18n_getters.getDataViewLabel)(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: this.state.options,
      value: this.props.value ? this.props.value : '',
      onChange: this._onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }));
  }
}
exports.IndexPatternSelect = IndexPatternSelect;