"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogEventsRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _savedSearchComponent = require("@kbn/saved-search-component");
var _esQuery = require("@kbn/es-query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/logs_shared/public/components/log_events/create_log_events_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_DISPLAY_OPTIONS = {
  solutionNavIdOverride: 'oblt',
  enableDocumentViewer: false,
  enableFilters: false
};
const createLogEventsRenderer = ({
  dataViews,
  embeddable,
  searchSource
}) => ({
  query,
  nonHighlightingQuery,
  timeRange,
  index,
  displayOptions = DEFAULT_DISPLAY_OPTIONS
}) => {
  // Convert user queries to ES filters that will be highlighted
  const documentFilters = (0, _react.useMemo)(() => {
    if (!(query !== null && query !== void 0 && query.query)) {
      return [];
    }
    try {
      const esQuery = (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(query.query));
      const filter = (0, _esQuery.buildCustomFilter)(index, esQuery, false, false, null, _esQuery.FilterStateStore.APP_STATE);
      return [filter];
    } catch (err) {
      return [];
    }
  }, [query, index]);

  // Convert context queries to ES filters that won't be highlighted
  const contextFilters = (0, _react.useMemo)(() => {
    if (!(nonHighlightingQuery !== null && nonHighlightingQuery !== void 0 && nonHighlightingQuery.query)) {
      return [];
    }
    try {
      const esQuery = (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(nonHighlightingQuery.query));
      const filter = (0, _esQuery.buildCustomFilter)(index, esQuery, false, false, null, _esQuery.FilterStateStore.APP_STATE);
      return [filter];
    } catch (err) {
      return [];
    }
  }, [nonHighlightingQuery, index]);
  return /*#__PURE__*/_react.default.createElement(_savedSearchComponent.LazySavedSearchComponent, (0, _extends2.default)({
    index: index,
    timeRange: timeRange
  }, documentFilters.length > 0 && {
    filters: documentFilters
  }, contextFilters.length > 0 && {
    nonHighlightingFilters: contextFilters
  }, {
    displayOptions: displayOptions,
    height: "100%",
    dependencies: {
      embeddable,
      searchSource,
      dataViews
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }));
};
exports.createLogEventsRenderer = createLogEventsRenderer;