"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _sections = require("./sections");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _shared_imports = require("../shared_imports");
var _eui = require("@elastic/eui");
var _locator = require("../locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/license_management/public/application/app.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const App = ({
  hasPermission,
  permissionsLoading,
  permissionsError,
  telemetry,
  loadPermissions,
  executionContext
}) => {
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'licenseManagement'
  });
  (0, _react.useEffect)(() => {
    loadPermissions();
  }, [loadPermissions]);
  if (permissionsLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.app.loadingPermissionsDescription",
      defaultMessage: "Checking permissions\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    })));
  }
  if (permissionsError) {
    var _permissionsError$dat;
    const error = permissionsError === null || permissionsError === void 0 ? void 0 : (_permissionsError$dat = permissionsError.data) === null || _permissionsError$dat === void 0 ? void 0 : _permissionsError$dat.message;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.app.checkingPermissionsErrorMessage",
        defaultMessage: "Error checking permissions",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 15
        }
      })),
      body: error ? /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 25
        }
      }, error) : null,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }));
  }
  if (!hasPermission) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "subdued",
      iconType: "securityApp",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.app.deniedPermissionTitle",
        defaultMessage: "Cluster privileges required",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 15
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.app.deniedPermissionDescription",
        defaultMessage: "To use License Management, you must have {permissionType} privileges.",
        values: {
          permissionType: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 89,
              columnNumber: 35
            }
          }, _constants.APP_PERMISSION)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 15
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }));
  }
  const withTelemetry = Component => props => /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
    telemetry: telemetry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 51
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/${_locator.UPLOAD_LICENSE_ROUTE}`,
    component: withTelemetry(_sections.UploadLicense),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/'],
    component: withTelemetry(_sections.LicenseDashboard),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })));
};
exports.App = App;