"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagcloudAppearanceSettings = TagcloudAppearanceSettings;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/expression-tagcloud-plugin/common");
var _font_size_input = require("./font_size_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/tagcloud/tagcloud_toolbar/appearance_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TagcloudAppearanceSettings(props) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.tagcloud.fontSizeLabel', {
      defaultMessage: 'Font size'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_font_size_input.FontSizeInput, {
    minFontSize: props.state.minFontSize,
    maxFontSize: props.state.maxFontSize,
    onChange: (minFontSize, maxFontSize) => {
      props.setState({
        ...props.state,
        minFontSize,
        maxFontSize
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.tagcloud.orientationLabel', {
      defaultMessage: 'Orientation'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: ORIENTATION_OPTIONS,
    value: props.state.orientation,
    onChange: event => {
      props.setState({
        ...props.state,
        orientation: event.target.value
      });
    },
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.tagcloud.showLabel', {
      defaultMessage: 'Show label'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.lens.label.tagcloud.showLabel', {
      defaultMessage: 'Show label'
    }),
    showLabel: false,
    checked: props.state.showLabel,
    onChange: event => {
      props.setState({
        ...props.state,
        showLabel: event.target.checked
      });
    },
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  })));
}
const ORIENTATION_OPTIONS = [{
  value: _common.Orientation.SINGLE,
  text: _i18n.i18n.translate('xpack.lens.label.tagcloud.orientation.single', {
    defaultMessage: 'Single'
  })
}, {
  value: _common.Orientation.RIGHT_ANGLED,
  text: _i18n.i18n.translate('xpack.lens.label.tagcloud.orientation.rightAngled', {
    defaultMessage: 'Right angled'
  })
}, {
  value: _common.Orientation.MULTIPLE,
  text: _i18n.i18n.translate('xpack.lens.label.tagcloud.orientation.multiple', {
    defaultMessage: 'Multiple'
  })
}];