"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatatableAppearanceSettings = DatatableAppearanceSettings;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lensCommon = require("@kbn/lens-common");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _table_basic = require("./table_basic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/datatable/components/appearance_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LEGACY_SINGLE_ROW_HEIGHT_MODE = 'single';
function DatatableAppearanceSettings({
  state,
  setState
}) {
  var _state$density, _state$headerRowHeigh, _state$rowHeight, _state$paging2;
  const [lineCounts, setLineCounts] = (0, _react.useState)({
    [_lensCommon.ROW_HEIGHT_LINES_KEYS.headerRowHeightLines]: state.headerRowHeightLines && state.headerRowHeightLines > 0 ? state.headerRowHeightLines : _lensCommon.DEFAULT_HEADER_ROW_HEIGHT_LINES,
    [_lensCommon.ROW_HEIGHT_LINES_KEYS.rowHeightLines]: state.rowHeightLines && state.rowHeightLines > 0 ? state.rowHeightLines : _lensCommon.DEFAULT_ROW_HEIGHT_LINES
  });
  const onChangeHeight = (0, _react.useCallback)((newHeightMode, heightProperty, heightLinesProperty) => {
    const newRowHeightLines = newHeightMode === _lensCommon.LENS_ROW_HEIGHT_MODE.auto ? _lensCommon.LENS_ROW_HEIGHT_MODE.auto : lineCounts[heightLinesProperty];
    setState({
      ...state,
      [heightProperty]: newHeightMode,
      [heightLinesProperty]: newRowHeightLines
    });
  }, [setState, state, lineCounts]);
  const onChangeHeightLines = (0, _react.useCallback)((newRowHeightLines, heightLinesProperty) => {
    setState({
      ...state,
      [heightLinesProperty]: newRowHeightLines
    });
    setLineCounts({
      ...lineCounts,
      [heightLinesProperty]: newRowHeightLines
    });
  }, [setState, state, lineCounts]);
  const onTogglePagination = (0, _react.useCallback)(() => {
    var _state$paging;
    const current = (_state$paging = state.paging) !== null && _state$paging !== void 0 ? _state$paging : {
      size: _table_basic.DEFAULT_PAGE_SIZE,
      enabled: false
    };
    setState({
      ...state,
      paging: {
        ...current,
        enabled: !current.enabled
      }
    });
  }, [setState, state]);
  const onChangeDensity = (0, _react.useCallback)(density => {
    setState({
      ...state,
      density
    });
  }, [setState, state]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DensitySettings, {
    dataGridDensity: (_state$density = state.density) !== null && _state$density !== void 0 ? _state$density : _lensCommon.LENS_DATAGRID_DENSITY.NORMAL,
    onChange: onChangeDensity,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_unifiedDataTable.RowHeightSettings, {
    rowHeight: (_state$headerRowHeigh = state.headerRowHeight) !== null && _state$headerRowHeigh !== void 0 ? _state$headerRowHeigh : _lensCommon.DEFAULT_HEADER_ROW_HEIGHT,
    label: _i18n.i18n.translate('xpack.lens.table.visualOptionsHeaderRowHeightLabel', {
      defaultMessage: 'Max header cell lines'
    }),
    onChangeRowHeight: mode => onChangeHeight(mode, 'headerRowHeight', _lensCommon.ROW_HEIGHT_LINES_KEYS.headerRowHeightLines),
    onChangeLineCountInput: lines => {
      onChangeHeightLines(lines, _lensCommon.ROW_HEIGHT_LINES_KEYS.headerRowHeightLines);
    },
    "data-test-subj": "lnsHeaderHeightSettings",
    maxRowHeight: 5,
    lineCountInput: lineCounts[_lensCommon.ROW_HEIGHT_LINES_KEYS.headerRowHeightLines],
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_unifiedDataTable.RowHeightSettings, {
    rowHeight:
    // @ts-ignore - saved state can contain legacy row height mode
    state.rowHeight === LEGACY_SINGLE_ROW_HEIGHT_MODE ? _lensCommon.LENS_ROW_HEIGHT_MODE.custom : (_state$rowHeight = state.rowHeight) !== null && _state$rowHeight !== void 0 ? _state$rowHeight : _lensCommon.DEFAULT_ROW_HEIGHT,
    label: _i18n.i18n.translate('xpack.lens.table.visualOptionsFitRowToContentLabel', {
      defaultMessage: 'Body cell lines'
    }),
    onChangeRowHeight: mode => onChangeHeight(mode, 'rowHeight', _lensCommon.ROW_HEIGHT_LINES_KEYS.rowHeightLines),
    onChangeLineCountInput: lines => {
      onChangeHeightLines(lines, _lensCommon.ROW_HEIGHT_LINES_KEYS.rowHeightLines);
    },
    "data-test-subj": "lnsRowHeightSettings",
    lineCountInput: lineCounts[_lensCommon.ROW_HEIGHT_LINES_KEYS.rowHeightLines],
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.table.visualOptionsPaginateTable', {
      defaultMessage: 'Paginate table'
    }),
    display: "columnCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.lens.table.visualOptionsPaginateTableTooltip', {
      defaultMessage: 'Pagination is hidden if there are less than 10 items'
    }),
    position: "right",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "lens-table-pagination-switch",
    label: "",
    showLabel: false,
    checked: Boolean((_state$paging2 = state.paging) === null || _state$paging2 === void 0 ? void 0 : _state$paging2.enabled),
    onChange: onTogglePagination,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }))));
}
const densityValues = Object.values(_lensCommon.LENS_DATAGRID_DENSITY);
const getValidDensity = density => {
  const isValidDensity = densityValues.includes(density);
  return isValidDensity ? density : _lensCommon.LENS_DATAGRID_DENSITY.NORMAL;
};
const densityLabel = _i18n.i18n.translate('xpack.lens.table.densityLabel', {
  defaultMessage: 'Density'
});
const densityOptions = [{
  id: _lensCommon.LENS_DATAGRID_DENSITY.COMPACT,
  label: _i18n.i18n.translate('xpack.lens.table.labelCompact', {
    defaultMessage: 'Compact'
  })
}, {
  id: _lensCommon.LENS_DATAGRID_DENSITY.NORMAL,
  label: _i18n.i18n.translate('xpack.lens.table.labelNormal', {
    defaultMessage: 'Normal'
  })
}, {
  id: _lensCommon.LENS_DATAGRID_DENSITY.EXPANDED,
  label: _i18n.i18n.translate('xpack.lens.table.labelExpanded', {
    defaultMessage: 'Expanded'
  })
}];
const DensitySettings = ({
  dataGridDensity,
  onChange
}) => {
  // Falls back to NORMAL density when an invalid density is provided
  const validDensity = getValidDensity(dataGridDensity);
  const setDensity = (0, _react.useCallback)(density => {
    onChange(getValidDensity(density));
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: densityLabel,
    "aria-label": densityLabel,
    display: "columnCompressed",
    "data-test-subj": "lnsDensitySettings",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: densityLabel,
    buttonSize: "compressed",
    isFullWidth: true,
    options: densityOptions,
    onChange: setDensity,
    idSelected: validDensity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  }));
};