"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendLocationSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/legend/location/legend_location_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const toggleButtonsIcons = [{
  id: _charts.Position.Right,
  label: _i18n.i18n.translate('xpack.lens.shared.legendPositionRight', {
    defaultMessage: 'Right'
  }),
  iconType: 'sortRight'
}, {
  id: _charts.Position.Left,
  label: _i18n.i18n.translate('xpack.lens.shared.legendPositionLeft', {
    defaultMessage: 'Left'
  }),
  iconType: 'sortLeft'
}, {
  id: _charts.Position.Top,
  label: _i18n.i18n.translate('xpack.lens.shared.legendPositionTop', {
    defaultMessage: 'Top'
  }),
  iconType: 'sortUp'
}, {
  id: _charts.Position.Bottom,
  label: _i18n.i18n.translate('xpack.lens.shared.legendPositionBottom', {
    defaultMessage: 'Bottom'
  }),
  iconType: 'sortDown'
}];
const locationOptions = [{
  id: `xy_location_outside`,
  value: 'outside',
  label: _i18n.i18n.translate('xpack.lens.xyChart.legendLocation.outside', {
    defaultMessage: 'Outside'
  })
}, {
  id: `xy_location_inside`,
  value: 'inside',
  label: _i18n.i18n.translate('xpack.lens.xyChart.legendLocation.inside', {
    defaultMessage: 'Inside'
  })
}];
const locationAlignmentButtonsIcons = [{
  id: 'xy_location_alignment_top_right',
  value: 'top_right',
  label: _i18n.i18n.translate('xpack.lens.shared.legendLocationTopRight', {
    defaultMessage: 'Top right'
  }),
  iconType: 'editorPositionTopRight'
}, {
  id: 'xy_location_alignment_top_left',
  value: 'top_left',
  label: _i18n.i18n.translate('xpack.lens.shared.legendLocationTopLeft', {
    defaultMessage: 'Top left'
  }),
  iconType: 'editorPositionTopLeft'
}, {
  id: 'xy_location_alignment_bottom_right',
  value: 'bottom_right',
  label: _i18n.i18n.translate('xpack.lens.shared.legendLocationBottomRight', {
    defaultMessage: 'Bottom right'
  }),
  iconType: 'editorPositionBottomRight'
}, {
  id: 'xy_location_alignment_bottom_left',
  value: 'bottom_left',
  label: _i18n.i18n.translate('xpack.lens.shared.legendLocationBottomLeft', {
    defaultMessage: 'Bottom left'
  }),
  iconType: 'editorPositionBottomLeft'
}];
const LegendLocationSettings = ({
  location,
  onLocationChange = () => {},
  position,
  onPositionChange,
  verticalAlignment,
  horizontalAlignment,
  onAlignmentChange = () => {},
  isDisabled = false
}) => {
  const alignment = `${verticalAlignment || _charts.VerticalAlignment.Top}_${horizontalAlignment || _charts.HorizontalAlignment.Right}`;
  if (isDisabled) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, location && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.shared.legendPosition', {
      defaultMessage: 'Position'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.shared.legendPosition', {
      defaultMessage: 'Position'
    }),
    "data-test-subj": "lens-legend-location-btn",
    buttonSize: "compressed",
    options: locationOptions,
    isDisabled: isDisabled,
    idSelected: locationOptions.find(({
      value
    }) => value === location).id,
    onChange: optionId => {
      const newLocation = locationOptions.find(({
        id
      }) => id === optionId).value;
      onLocationChange(newLocation);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (!location || location === 'outside') && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.shared.legendAlignmentLabel', {
      defaultMessage: 'Alignment'
    }),
    isDisabled: isDisabled,
    "data-test-subj": "lens-legend-position-btn",
    buttonSize: "compressed",
    options: toggleButtonsIcons,
    idSelected: position || _charts.Position.Right,
    onChange: onPositionChange,
    isIconOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 19
    }
  }), location === 'inside' && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.shared.legendInsideLocationAlignmentLabel', {
      defaultMessage: 'Alignment'
    }),
    type: "single",
    "data-test-subj": "lens-legend-inside-alignment-btn",
    buttonSize: "compressed",
    isDisabled: isDisabled,
    options: locationAlignmentButtonsIcons,
    idSelected: locationAlignmentButtonsIcons.find(({
      value
    }) => value === alignment).id,
    onChange: optionId => {
      const newAlignment = locationAlignmentButtonsIcons.find(({
        id
      }) => id === optionId).value;
      onAlignmentChange(newAlignment);
    },
    isIconOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 19
    }
  }))))));
};
exports.LegendLocationSettings = LegendLocationSettings;