"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensFeatureFlags = getLensFeatureFlags;
exports.setLensFeatureFlags = setLensFeatureFlags;
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const [getFeatureFlags, setFeatureFlags] = (0, _public.createGetterSetter)('LensFeatureFlags', false);

/**
 * Retrieves all Lens features flags
 *
 * Does not support dynamic changes to flag values
 */
function getLensFeatureFlags() {
  const flags = getFeatureFlags();
  if (flags) return flags;
  return (0, _common.getLensFeatureFlagDefaults)();
}
async function setLensFeatureFlags(service) {
  const flags = await (0, _common.fetchLensFeatureFlags)(service);
  setFeatureFlags(flags);
  return flags;
}