"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.downloadCsvLensShareProvider = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/data-plugin/common");
var _public = require("@kbn/share-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/app_plugin/csv_download_provider/csv_download_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function downloadCSVs({
  title,
  datatables,
  formatFactory,
  uiSettings
}) {
  if (datatables.length === 0) {
    if (window.ELASTIC_LENS_CSV_DOWNLOAD_DEBUG) {
      window.ELASTIC_LENS_CSV_CONTENT = undefined;
    }
    return;
  }
  const content = datatables.reduce((memo, datatable, i) => {
    // skip empty datatables
    if (datatable) {
      const postFix = datatables.length > 1 ? `-${i + 1}` : '';
      memo[`${title}${postFix}.csv`] = {
        content: _public2.exporters.datatableToCSV(datatable, {
          csvSeparator: uiSettings.get('csv:separator', ','),
          quoteValues: uiSettings.get('csv:quoteValues', true),
          formatFactory,
          escapeFormulaValues: false
        }),
        type: _public2.exporters.CSV_MIME_TYPE
      };
    }
    return memo;
  }, {});
  if (window.ELASTIC_LENS_CSV_DOWNLOAD_DEBUG) {
    window.ELASTIC_LENS_CSV_CONTENT = content;
  }
  if (content) {
    (0, _public.downloadMultipleAs)(content);
  }
}
function getWarnings(datatables) {
  const warnings = [];
  const formulaDetected = datatables.some(datatable => {
    return (0, _common.tableHasFormulas)(datatable.columns, datatable.rows);
  });
  if (formulaDetected) {
    warnings.push({
      title: _i18n.i18n.translate('xpack.lens.app.downloadButtonFormulasWarningTitle', {
        defaultMessage: 'Formulas detected'
      }),
      message: _i18n.i18n.translate('xpack.lens.app.downloadButtonFormulasWarningMessage', {
        defaultMessage: 'Your CSV contains characters that spreadsheet applications might interpret as formulas.'
      })
    });
  }
  return warnings;
}
const downloadCsvLensShareProvider = ({
  uiSettings,
  formatFactoryFn,
  atLeastGold
}) => {
  return {
    id: 'csvDownloadLens',
    groupId: 'export',
    getShareIntegrationConfig: async ({
      sharingData
    }) => {
      // TODO fix sharingData types
      const {
        title,
        datatables,
        csvEnabled
      } = sharingData;
      const panelTitle = _i18n.i18n.translate('xpack.lens.reporting.shareContextMenu.csvReportsButtonLabel', {
        defaultMessage: 'CSV Download'
      });
      const downloadCSVHandler = () => downloadCSVs({
        title,
        formatFactory: formatFactoryFn(),
        datatables,
        uiSettings
      });
      return {
        id: 'csvDownloadLens',
        name: panelTitle,
        icon: 'tableDensityNormal',
        sortOrder: 1,
        label: 'CSV',
        exportType: 'lens_csv',
        supportedLayoutOptions: ['print'],
        requiresSavedState: false,
        generateAssetExport: downloadCSVHandler,
        warnings: getWarnings(datatables),
        ...(atLeastGold() ? {
          disabled: !csvEnabled,
          renderLayoutOptionSwitch: false,
          getJobParams: undefined
        } : {
          helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.lens.application.csvPanelContent.generationDescription",
            defaultMessage: "Download the data displayed in the visualization.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 154,
              columnNumber: 17
            }
          }),
          generateExportButtonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.lens.share.csvButton",
            defaultMessage: "Download CSV",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 160,
              columnNumber: 17
            }
          })
        })
      };
    }
  };
};
exports.downloadCsvLensShareProvider = downloadCsvLensShareProvider;