"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LENS_GAUGE_ID = exports.LENS_GAUGE_GROUP_ID = exports.GAUGE_TITLES_BY_TYPE = exports.GAUGE_TICKS_POSITIONS = exports.GAUGE_SHAPES = exports.GAUGE_LABEL_MAJOR_MODES = exports.GAUGE_COLOR_MODES = exports.GAUGE_CENTRAL_MAJOR_MODES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LENS_GAUGE_ID = exports.LENS_GAUGE_ID = 'lnsGauge';
const GAUGE_SHAPES = exports.GAUGE_SHAPES = {
  HORIZONTAL_BULLET: 'horizontalBullet',
  VERTICAL_BULLET: 'verticalBullet',
  SEMI_CIRCLE: 'semiCircle',
  ARC: 'arc',
  CIRCLE: 'circle'
};
const GAUGE_TICKS_POSITIONS = exports.GAUGE_TICKS_POSITIONS = {
  HIDDEN: 'hidden',
  AUTO: 'auto',
  BANDS: 'bands'
};
const GAUGE_LABEL_MAJOR_MODES = exports.GAUGE_LABEL_MAJOR_MODES = {
  AUTO: 'auto',
  CUSTOM: 'custom',
  NONE: 'none'
};
const GAUGE_CENTRAL_MAJOR_MODES = exports.GAUGE_CENTRAL_MAJOR_MODES = {
  AUTO: 'auto',
  CUSTOM: 'custom',
  NONE: 'none'
};
const GAUGE_COLOR_MODES = exports.GAUGE_COLOR_MODES = {
  PALETTE: 'palette',
  NONE: 'none'
};
const LENS_GAUGE_GROUP_ID = exports.LENS_GAUGE_GROUP_ID = {
  METRIC: 'metric',
  MIN: 'min',
  MAX: 'max',
  GOAL: 'goal'
};
const GAUGE_TITLES_BY_TYPE = exports.GAUGE_TITLES_BY_TYPE = {
  [GAUGE_SHAPES.HORIZONTAL_BULLET]: _i18n.i18n.translate('xpack.lens.gaugeHorizontal.gaugeLabel', {
    defaultMessage: 'Horizontal Bullet'
  }),
  [GAUGE_SHAPES.VERTICAL_BULLET]: _i18n.i18n.translate('xpack.lens.gaugeVertical.gaugeLabel', {
    defaultMessage: 'Vertical Bullet'
  }),
  [GAUGE_SHAPES.SEMI_CIRCLE]: _i18n.i18n.translate('xpack.lens.gaugeSemiCircle.gaugeLabel', {
    defaultMessage: 'Minor arc'
  }),
  [GAUGE_SHAPES.ARC]: _i18n.i18n.translate('xpack.lens.gaugeArc.gaugeLabel', {
    defaultMessage: 'Major arc'
  }),
  [GAUGE_SHAPES.CIRCLE]: _i18n.i18n.translate('xpack.lens.gaugeCircle.gaugeLabel', {
    defaultMessage: 'Circle'
  })
};