"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XJsonEditor = void 0;
var _monaco = require("@kbn/monaco");
var _react = _interopRequireWildcard(require("react"));
var _text_editor = require("./text_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/field_components/xjson_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultEditorOptions = {
  minimap: {
    enabled: false
  },
  lineNumbers: 'off'
};
const XJsonEditor = ({
  field,
  editorProps,
  disabled
}) => {
  const {
    value,
    setValue
  } = field;
  const onChange = (0, _react.useCallback)(s => {
    setValue(s);
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_text_editor.TextEditor, {
    field: field,
    editorProps: {
      value,
      languageId: _monaco.XJsonLang.ID,
      options: defaultEditorOptions,
      onChange,
      ...editorProps
    },
    euiFieldProps: {
      disabled
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
};
exports.XJsonEditor = XJsonEditor;