"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodesOverview = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _ebtTools = require("@kbn/ebt-tools");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _moment = _interopRequireDefault(require("moment"));
var _switch_schema_message = require("../../../../components/shared/switch_schema_message");
var _use_time_range_metadata = require("../../../../hooks/use_time_range_metadata");
var _empty_states = require("../../../../components/empty_states");
var _loading = require("../../../../components/loading");
var _map = require("./waffle/map");
var _table_view = require("./table_view");
var _calculate_bounds_from_nodes = require("../lib/calculate_bounds_from_nodes");
var _legend = require("./waffle/legend");
var _use_asset_details_flyout_url_state = require("../hooks/use_asset_details_flyout_url_state");
var _asset_details_flyout = require("./waffle/asset_details_flyout");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _use_waffle_time = require("../hooks/use_waffle_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/nodes_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NodesOverview = ({
  autoBounds,
  boundsOverride,
  loading,
  nodes,
  nodeType,
  view,
  currentTime,
  options,
  formatter,
  onDrilldown,
  bottomMargin,
  showLoading,
  refreshInterval,
  isAutoReloading
}) => {
  const currentBreakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const [{
    detailsItemId,
    entityType
  }, setFlyoutUrlState] = (0, _use_asset_details_flyout_url_state.useAssetDetailsFlyoutState)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    jumpToTime
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    data: timeRangeMetadata
  } = (0, _use_time_range_metadata.useTimeRangeMetadataContext)();
  const {
    preferredSchema
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const schemas = (0, _react.useMemo)(() => (timeRangeMetadata === null || timeRangeMetadata === void 0 ? void 0 : timeRangeMetadata.schemas) || [], [timeRangeMetadata === null || timeRangeMetadata === void 0 ? void 0 : timeRangeMetadata.schemas]);
  const nodeName = (0, _react.useMemo)(() => {
    var _nodes$find;
    return (_nodes$find = nodes.find(node => node.path[0].value === detailsItemId)) === null || _nodes$find === void 0 ? void 0 : _nodes$find.name;
  }, [detailsItemId, nodes]);
  const closeFlyout = (0, _react.useCallback)(() => setFlyoutUrlState({
    detailsItemId: null,
    entityType: null
  }), [setFlyoutUrlState]);
  const handleDrilldown = (0, _react.useCallback)(filter => {
    onDrilldown(filter);
    return;
  }, [onDrilldown]);
  const noData = !loading && nodes && nodes.length === 0;
  const hasDataOnAnotherSchema = schemas.length === 1 && preferredSchema !== schemas[0];
  const refetchProps = hasDataOnAnotherSchema ? {} : {
    refetchText: _i18n.i18n.translate('xpack.infra.waffle.checkNewDataButtonLabel', {
      defaultMessage: 'Check for new data'
    }),
    onRefetch: () => {
      jumpToTime((0, _moment.default)().valueOf());
    }
  };
  if (loading && showLoading) {
    // Don't show loading screen when we're auto-reloading
    return /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
      height: "100%",
      width: "100%",
      text: _i18n.i18n.translate('xpack.infra.waffle.loadingDataText', {
        defaultMessage: 'Loading data'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 7
      }
    });
  } else if (noData) {
    return /*#__PURE__*/_react.default.createElement(_empty_states.NoData, (0, _extends2.default)({
      titleText: _i18n.i18n.translate('xpack.infra.waffle.noDataTitle', {
        defaultMessage: 'There is no data to display.'
      }),
      bodyText: hasDataOnAnotherSchema ? /*#__PURE__*/_react.default.createElement(_switch_schema_message.SwitchSchemaMessage, {
        dataTestSubj: "infraInventoryViewNoDataInSelectedSchema",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 13
        }
      }) : _i18n.i18n.translate('xpack.infra.waffle.noDataDescription', {
        defaultMessage: 'Try adjusting your time or filter.'
      })
    }, refetchProps, {
      testString: "noMetricsDataPrompt",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 7
      }
    }));
  }
  const dataBounds = (0, _calculate_bounds_from_nodes.calculateBoundsFromNodes)(nodes);
  const bounds = autoBounds ? dataBounds : boundsOverride;
  const isStatic = ['xs', 's'].includes(currentBreakpoint);
  if (!loading) {
    onPageReady();
  }
  if (view === 'table') {
    return /*#__PURE__*/_react.default.createElement(TableContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_table_view.TableView, {
      nodeType: nodeType,
      nodes: nodes,
      options: options,
      formatter: formatter,
      currentTime: currentTime,
      onFilter: handleDrilldown,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 9
      }
    }), nodeType === entityType && detailsItemId && /*#__PURE__*/_react.default.createElement(_asset_details_flyout.AssetDetailsFlyout, {
      entityId: detailsItemId,
      entityName: nodeName,
      entityType: nodeType,
      closeFlyout: closeFlyout,
      currentTime: currentTime,
      isAutoReloading: isAutoReloading,
      options: options,
      refreshInterval: refreshInterval,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 11
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(MapContainer, {
    positionStatic: isStatic,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_map.Map, {
    nodeType: nodeType,
    nodes: nodes,
    detailsItemId: detailsItemId,
    options: options,
    formatter: formatter,
    currentTime: currentTime,
    onFilter: handleDrilldown,
    bounds: bounds,
    bottomMargin: bottomMargin,
    staticHeight: isStatic,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }), nodeType === entityType && detailsItemId && /*#__PURE__*/_react.default.createElement(_asset_details_flyout.AssetDetailsFlyout, {
    entityId: detailsItemId,
    entityName: nodeName,
    entityType: nodeType,
    closeFlyout: closeFlyout,
    currentTime: currentTime,
    isAutoReloading: isAutoReloading,
    options: options,
    refreshInterval: refreshInterval,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    formatter: formatter,
    bounds: bounds,
    dataBounds: dataBounds,
    legend: options.legend,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }));
};
exports.NodesOverview = NodesOverview;
const TableContainer = _styled.default.div`
  padding: ${props => props.theme.euiTheme.size.l};
`;
const MapContainer = _styled.default.div`
  position: ${props => props.positionStatic ? 'static' : 'absolute'};
  display: flex;
  top: 0;
  right: 0;
  bottom: 0;
  left: 0;
`;