"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostsTableContext = exports.useHostsTable = exports.HostsTableProvider = exports.HostsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constate = _interopRequireDefault(require("constate"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _lodash = require("lodash");
var _fp = require("lodash/fp");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../components/asset_details/constants");
var _popover = require("../../../../components/asset_details/tabs/common/popover");
var _constants2 = require("../../../../../common/constants");
var _use_kibana = require("../../../../hooks/use_kibana");
var _create_inventory_metric_formatter = require("../../inventory_view/lib/create_inventory_metric_formatter");
var _entry_title = require("../components/table/entry_title");
var _use_hosts_table_url_state = require("./use_hosts_table_url_state");
var _use_hosts_view = require("./use_hosts_view");
var _metrics_source = require("../../../../containers/metrics_source");
var _column_header = require("../components/table/column_header");
var _translations = require("../translations");
var _visualizations = require("../../../../common/visualizations");
var _build = require("../../../../utils/filters/build");
var _add_data_troubleshooting_popover = require("../components/table/add_data_troubleshooting_popover");
var _use_unified_search = require("./use_unified_search");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/hooks/use_hosts_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Columns and items types
 */

/**
 * Helper functions
 */
const formatMetric = (type, value) => {
  const defaultValue = value !== null && value !== void 0 ? value : 0;
  return (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
    type
  })(defaultValue);
};
const buildMetricCell = (value, formatType, hasSystemMetrics) => {
  if (!hasSystemMetrics && value === null) {
    return /*#__PURE__*/_react.default.createElement(_add_data_troubleshooting_popover.AddDataTroubleshootingPopover, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 12
      }
    });
  }
  return formatMetric(formatType, value);
};
const buildItemsList = nodes => {
  return nodes.map(({
    metrics,
    metadata,
    name,
    alertsCount,
    hasSystemMetrics
  }) => {
    var _metadataKeyValue$hos, _ref, _metadataKeyValue$hos2, _metadataKeyValue$hos3;
    const metadataKeyValue = metadata.reduce((acc, curr) => ({
      ...acc,
      [curr.name]: curr.value
    }), {});
    return {
      name,
      id: `${name}-${(_metadataKeyValue$hos = metadataKeyValue['host.os.name']) !== null && _metadataKeyValue$hos !== void 0 ? _metadataKeyValue$hos : '-'}`,
      title: {
        name,
        cloudProvider: (_ref = metadataKeyValue['cloud.provider']) !== null && _ref !== void 0 ? _ref : null
      },
      os: (_metadataKeyValue$hos2 = metadataKeyValue['host.os.name']) !== null && _metadataKeyValue$hos2 !== void 0 ? _metadataKeyValue$hos2 : '-',
      ip: (_metadataKeyValue$hos3 = metadataKeyValue['host.ip']) !== null && _metadataKeyValue$hos3 !== void 0 ? _metadataKeyValue$hos3 : '',
      ...metrics.reduce((acc, curr) => ({
        ...acc,
        [curr.name]: curr.value
      }), {}),
      hasSystemMetrics,
      alertsCount: alertsCount !== null && alertsCount !== void 0 ? alertsCount : 0
    };
  });
};
const isTitleColumn = cell => {
  return cell !== null && typeof cell === 'object' && cell && 'name' in cell;
};
const sortValues = (aValue, bValue, {
  direction
}) => {
  const a = aValue !== null && aValue !== void 0 ? aValue : -1;
  const b = bValue !== null && bValue !== void 0 ? bValue : -1;
  if (typeof a === 'string' && typeof b === 'string') {
    return direction === 'desc' ? b.localeCompare(a) : a.localeCompare(b);
  }
  if ((0, _fp.isNumber)(a) && (0, _fp.isNumber)(b)) {
    return direction === 'desc' ? b - a : a - b;
  }
  return 1;
};
const sortTableData = ({
  direction,
  field
}) => (a, b) => {
  const aValue = a[field];
  const bValue = b[field];
  if (isTitleColumn(aValue) && isTitleColumn(bValue)) {
    return sortValues(aValue.name, bValue.name, {
      direction,
      field
    });
  }
  return sortValues(aValue, bValue, {
    direction,
    field
  });
};

/**
 * Build a table columns and items starting from the snapshot nodes.
 */
const useHostsTable = () => {
  const inventoryModel = (0, _common.findInventoryModel)('host');
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const {
    hostNodes
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const displayAlerts = hostNodes.some(item => 'alertsCount' in item);
  const showApmHostTroubleshooting = hostNodes.some(item => !item.hasSystemMetrics);
  const {
    value: formulas
  } = (0, _useAsync.default)(() => {
    var _searchCriteria$prefe;
    return inventoryModel.metrics.getFormulas({
      schema: (_searchCriteria$prefe = searchCriteria.preferredSchema) !== null && _searchCriteria$prefe !== void 0 ? _searchCriteria$prefe : 'ecs'
    });
  }, [inventoryModel.metrics, searchCriteria.preferredSchema]);
  const [{
    detailsItemId,
    pagination,
    sorting
  }, setProperties] = (0, _use_hosts_table_url_state.useHostsTableUrlState)();
  const {
    services: {
      telemetry,
      data: {
        query: {
          filterManager: filterManagerService
        }
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const closeFlyout = (0, _react.useCallback)(() => setProperties({
    detailsItemId: null
  }), [setProperties]);
  const onSelectionChange = newSelectedItems => {
    setSelectedItems(newSelectedItems);
  };
  const filterSelectedHosts = (0, _react.useCallback)(() => {
    if (!selectedItems.length) {
      return [];
    }
    const selectedHostNames = selectedItems.map(({
      name
    }) => name);
    const newFilter = (0, _build.buildCombinedAssetFilter)({
      field: _constants2.HOST_NAME_FIELD,
      values: selectedHostNames,
      dataView: metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference
    });
    filterManagerService.addFilters(newFilter);
    setSelectedItems([]);
  }, [filterManagerService, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, selectedItems]);
  const reportHostEntryClick = (0, _react.useCallback)(({
    name,
    cloudProvider
  }) => {
    telemetry.reportHostEntryClicked({
      hostname: name,
      cloud_provider: cloudProvider
    });
  }, [telemetry]);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    const {
      index: pageIndex,
      size: pageSize
    } = page;
    const {
      field,
      direction
    } = sort !== null && sort !== void 0 ? sort : {};
    const currentSorting = {
      field: field,
      direction
    };
    const currentPagination = {
      pageIndex,
      pageSize
    };
    if (!(0, _lodash.isEqual)(sorting, currentSorting)) {
      setProperties({
        sorting: currentSorting
      });
    } else if (!(0, _lodash.isEqual)(pagination, currentPagination)) {
      setProperties({
        pagination: currentPagination
      });
    }
  }, [setProperties, pagination, sorting]);
  const items = (0, _react.useMemo)(() => buildItemsList(hostNodes), [hostNodes]);
  const clickedItem = (0, _react.useMemo)(() => items.find(({
    id
  }) => id === detailsItemId), [detailsItemId, items]);
  const currentPage = (0, _react.useMemo)(() => {
    const {
      pageSize = 0,
      pageIndex = 0
    } = pagination;
    const endIndex = (pageIndex + 1) * pageSize;
    const startIndex = pageIndex * pageSize;
    return items.sort(sortTableData(sorting)).slice(startIndex, endIndex);
  }, [items, pagination, sorting]);
  const showNetworkColumns = searchCriteria.preferredSchema !== 'semconv';
  const metricColumnsWidth = (0, _react.useMemo)(() => {
    if (displayAlerts) {
      return showNetworkColumns ? '12%' : '16%';
    }
    return showNetworkColumns ? '16%' : '20%';
  }, [displayAlerts, showNetworkColumns]);
  const titleColumnWidth = (0, _react.useMemo)(() => {
    if (displayAlerts) {
      return showNetworkColumns ? '15%' : '20%';
    }
    return showNetworkColumns ? '20%' : '25%';
  }, [displayAlerts, showNetworkColumns]);
  const columns = (0, _react.useMemo)(() => [{
    name: '',
    width: '40px',
    field: 'id',
    actions: [{
      name: _translations.TABLE_COLUMN_LABEL.toggleDialogAction,
      description: _translations.TABLE_COLUMN_LABEL.toggleDialogAction,
      icon: ({
        id
      }) => id === detailsItemId ? 'minimize' : 'expand',
      type: 'icon',
      'data-test-subj': 'hostsView-flyout-button',
      onClick: ({
        id
      }) => {
        setProperties({
          detailsItemId: id === detailsItemId ? null : id
        });
      }
    }]
  }, ...(displayAlerts ? [{
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.alertsCount,
      toolTip: _visualizations.METRICS_TOOLTIP.alertsCount,
      showDocumentationLink: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 17
      }
    }),
    width: '80px',
    field: 'alertsCount',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-alertsCount',
    render: (alertsCount, row) => {
      if (!alertsCount) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _translations.TABLE_CONTENT_LABEL.activeAlerts,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 299,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        iconType: "warning",
        "data-test-subj": "hostInventoryAlertsBadgeLink",
        color: "danger",
        onClick: () => {
          setProperties({
            detailsItemId: row.id === detailsItemId ? null : row.id
          });
        },
        onClickAriaLabel: _translations.TABLE_CONTENT_LABEL.activeAlerts,
        iconOnClick: () => {
          setProperties({
            detailsItemId: row.id === detailsItemId ? null : row.id
          });
        },
        iconOnClickAriaLabel: _translations.TABLE_CONTENT_LABEL.activeAlerts,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 300,
          columnNumber: 21
        }
      }, alertsCount));
    }
  }] : []), ...(showApmHostTroubleshooting ? [{
    name: '',
    width: '20px',
    field: 'hasSystemMetrics',
    sortable: false,
    'data-test-subj': 'hostsView-tableRow-hasSystemMetrics',
    render: hasSystemMetrics => {
      if (hasSystemMetrics) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_popover.Popover, {
        icon: "question",
        "data-test-subj": "hostsView-tableRow-hasSystemMetrics-popover",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 334,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 338,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 339,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.hostsViewPage.table.tooltip.apmHostMessage",
        defaultMessage: "This host has been detected by {apm}",
        values: {
          apm: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "hostsViewTooltipApmDocumentationLink",
            href: " https://www.elastic.co/guide/en/observability/current/apm.html",
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 345,
              columnNumber: 31
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.infra.hostsViewPage.table.tooltip.apmHostMessage.apmDocumentationLink",
            defaultMessage: "APM",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 350,
              columnNumber: 33
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 340,
          columnNumber: 25
        }
      })), /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 359,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "hostsView-tableRow-hasSystemMetrics-learnMoreLink",
        href: _constants.APM_HOST_TROUBLESHOOTING_LINK,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 360,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.hostsViewPage.table.tooltip.learnMoreLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 27
        }
      })))));
    }
  }] : []), {
    name: _translations.TABLE_COLUMN_LABEL.title,
    field: 'title',
    sortable: true,
    truncateText: true,
    'data-test-subj': 'hostsView-tableRow-title',
    render: title => /*#__PURE__*/_react.default.createElement(_entry_title.EntryTitle, {
      title: title,
      onClick: () => reportHostEntryClick(title),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 385,
        columnNumber: 11
      }
    }),
    width: titleColumnWidth
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.cpuUsage,
      toolTip: _visualizations.METRICS_TOOLTIP.cpuUsage,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.get('cpuUsage').value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 11
      }
    }),
    width: metricColumnsWidth,
    field: 'cpuV2',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-cpuUsage',
    render: (avg, {
      hasSystemMetrics
    }) => buildMetricCell(avg, 'cpuV2', hasSystemMetrics),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.normalizedLoad1m,
      toolTip: _visualizations.METRICS_TOOLTIP.normalizedLoad1m,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.get('normalizedLoad1m').value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 407,
        columnNumber: 11
      }
    }),
    width: metricColumnsWidth,
    field: 'normalizedLoad1m',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-normalizedLoad1m',
    render: (avg, {
      hasSystemMetrics
    }) => buildMetricCell(avg, 'normalizedLoad1m', hasSystemMetrics),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.memoryUsage,
      toolTip: _visualizations.METRICS_TOOLTIP.memoryUsage,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.get('memoryUsage').value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 423,
        columnNumber: 11
      }
    }),
    width: metricColumnsWidth,
    field: 'memory',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-memoryUsage',
    render: (avg, {
      hasSystemMetrics
    }) => buildMetricCell(avg, 'memory', hasSystemMetrics),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.memoryFree,
      toolTip: _visualizations.METRICS_TOOLTIP.memoryFree,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.get('memoryFree').value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 439,
        columnNumber: 11
      }
    }),
    width: metricColumnsWidth,
    field: 'memoryFree',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-memoryFree',
    render: (avg, {
      hasSystemMetrics
    }) => buildMetricCell(avg, 'memoryFree', hasSystemMetrics),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.diskSpaceUsage,
      toolTip: _visualizations.METRICS_TOOLTIP.diskUsage,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.get('diskUsage').value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 455,
        columnNumber: 11
      }
    }),
    width: metricColumnsWidth,
    field: 'diskSpaceUsage',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-diskSpaceUsage',
    render: (max, {
      hasSystemMetrics
    }) => buildMetricCell(max, 'diskSpaceUsage', hasSystemMetrics),
    align: 'right'
  }, ...(searchCriteria.preferredSchema !== 'semconv' ? [{
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 474,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 475,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.infra.hostsViewPage.table.rx.screenReaderOnlyLabel', {
      defaultMessage: 'Network Inbound'
    }))), /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.rx,
      toolTip: _visualizations.METRICS_TOOLTIP.rx,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.get('rx').value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 481,
        columnNumber: 19
      }
    })),
    width: '12%',
    field: 'rxV2',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-rx',
    render: (avg, {
      hasSystemMetrics
    }) => buildMetricCell(avg, 'rx', hasSystemMetrics),
    align: 'right'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 499,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 500,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.infra.hostsViewPage.table.tx.screenReaderOnlyLabel', {
      defaultMessage: 'Network Outbound'
    }))), /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
      label: _translations.TABLE_COLUMN_LABEL.tx,
      toolTip: _visualizations.METRICS_TOOLTIP.tx,
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.get('tx').value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 506,
        columnNumber: 19
      }
    })),
    width: '12%',
    field: 'txV2',
    sortable: true,
    'data-test-subj': 'hostsView-tableRow-tx',
    render: (avg, {
      hasSystemMetrics
    }) => buildMetricCell(avg, 'tx', hasSystemMetrics),
    align: 'right'
  }] : [])], [displayAlerts, showApmHostTroubleshooting, formulas, metricColumnsWidth, titleColumnWidth, searchCriteria.preferredSchema, detailsItemId, setProperties, reportHostEntryClick]);
  const selection = {
    onSelectionChange,
    selectable: item => !!item.name,
    selected: selectedItems
  };
  return {
    columns,
    clickedItem,
    currentPage,
    closeFlyout,
    items,
    isFlyoutOpen: detailsItemId !== null,
    onTableChange,
    pagination,
    sorting,
    selection,
    selectedItemsCount: selectedItems.length,
    filterSelectedHosts
  };
};
exports.useHostsTable = useHostsTable;
const HostsTable = exports.HostsTable = (0, _constate.default)(useHostsTable);
const [HostsTableProvider, useHostsTableContext] = HostsTable;
exports.useHostsTableContext = useHostsTableContext;
exports.HostsTableProvider = HostsTableProvider;