"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createResultsUrl = exports.INFRA_ML_FLYOUT_FEEDBACK_LINK = exports.FlyoutHome = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/ml-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _react2 = require("@emotion/react");
var _log_analysis_setup = require("../../logging/log_analysis_setup");
var _module = require("../../../containers/ml/modules/metrics_hosts/module");
var _module2 = require("../../../containers/ml/modules/metrics_k8s/module");
var _loading_page = require("../../loading_page");
var _anomalies_table = require("./anomalies_table/anomalies_table");
var _subscription_splash_content = require("../../subscription_splash_content");
var _infra_ml_capabilities = require("../../../containers/ml/infra_ml_capabilities");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/ml/anomaly_detection/flyout_home.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INFRA_ML_FLYOUT_FEEDBACK_LINK = exports.INFRA_ML_FLYOUT_FEEDBACK_LINK = 'https://ela.st/infra-anomaly-feedback';
const FlyoutHome = props => {
  const [tab, setTab] = (0, _react.useState)('jobs');
  const [selectedJobType, setSelectedJobType] = (0, _react.useState)(_anomalies_table.JOB_OPTIONS[0].id === 'hosts' ? 'host' : 'pod');
  const {
    goToSetup,
    closeFlyout
  } = props;
  const {
    fetchJobStatus: fetchHostJobStatus,
    setupStatus: hostSetupStatus,
    jobSummaries: hostJobSummaries
  } = (0, _module.useMetricHostsModuleContext)();
  const {
    fetchJobStatus: fetchK8sJobStatus,
    setupStatus: k8sSetupStatus,
    jobSummaries: k8sJobSummaries
  } = (0, _module2.useMetricK8sModuleContext)();
  const {
    hasInfraMLCapabilities,
    hasInfraMLReadCapabilities,
    hasInfraMLSetupCapabilities
  } = (0, _infra_ml_capabilities.useInfraMLCapabilitiesContext)();
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = (0, _react.useContext)(_use_kibana.KibanaEnvironmentContext);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const createHosts = (0, _react.useCallback)(() => {
    goToSetup('hosts');
  }, [goToSetup]);
  const createK8s = (0, _react.useCallback)(() => {
    goToSetup('kubernetes');
  }, [goToSetup]);
  const onJobTypeChange = (0, _react.useCallback)(jobType => {
    setSelectedJobType(jobType);
  }, []);
  const jobIds = [...(k8sJobSummaries || []).map(k => k.id), ...(hostJobSummaries || []).map(h => h.id)];
  (0, _react.useEffect)(() => {
    if (hasInfraMLReadCapabilities) {
      fetchHostJobStatus();
      fetchK8sJobStatus();
    }
  }, [fetchK8sJobStatus, fetchHostJobStatus, hasInfraMLReadCapabilities]);
  const hasJobs = hostJobSummaries.length > 0 || k8sJobSummaries.length > 0;
  const manageJobsLinkProps = (0, _public2.useLinkProps)({
    app: 'management',
    pathname: 'ml/anomaly_detection'
  });

  // Used for prefilling the feedback form (if both types are enabled do not prefill)
  // In case the host type is the only option (if props.hideJobType is true) - prefill 'host'
  // If we are in the anomalies tab, use the selected job type
  const mlJobTypeByNode = props.hideJobType || hostJobSummaries.length > 0 && k8sJobSummaries.length === 0 ? 'host' : hostJobSummaries.length === 0 && k8sJobSummaries.length > 0 ? 'pod' : tab === 'anomalies' ? selectedJobType : undefined;
  if (!hasInfraMLCapabilities) {
    return /*#__PURE__*/_react.default.createElement(_subscription_splash_content.SubscriptionSplashPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 12
      }
    });
  } else if (!hasInfraMLReadCapabilities) {
    return /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingResultsPrivilegesPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 12
      }
    });
  } else if (hostSetupStatus.type === 'initializing' || k8sSetupStatus.type === 'initializing') {
    return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPrompt, {
      message: _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.jobStatusLoadingMessage', {
        defaultMessage: 'Checking status of metrics jobs...'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 7
      }
    });
  } else if (!hasInfraMLSetupCapabilities) {
    return /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingSetupPrivilegesPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 12
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Machine Learning anomaly detection",
      id: "xpack.infra.ml.anomalyFlyout.flyoutHeader",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 19
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: (0, _react2.css)`
                margin-right: ${euiTheme.size.l};
              `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_public2.FeatureFeedbackButton, {
      "data-test-subj": mlJobTypeByNode ? `infraML${mlJobTypeByNode}FlyoutFeedbackLink` : 'infraMLFlyoutFeedbackLink',
      formUrl: INFRA_ML_FLYOUT_FEEDBACK_LINK,
      sanitizedPath: document.location.pathname,
      kibanaVersion: kibanaVersion,
      isCloudEnv: isCloudEnv,
      isServerlessEnv: isServerlessEnv,
      nodeType: mlJobTypeByNode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      bottomBorder: true,
      css: (0, _react2.css)`
              margin-bottom: calc(-1 * (${euiTheme.size.l} + 1px));
            `,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: tab === 'jobs',
      onClick: () => setTab('jobs'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.jobsTabLabel', {
      defaultMessage: 'Jobs'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: tab === 'anomalies',
      onClick: () => setTab('anomalies'),
      "data-test-subj": "anomalyFlyoutAnomaliesTab",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.anomaliesTabLabel', {
      defaultMessage: 'Anomalies'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      banner: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tab === 'jobs' && hasJobs && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(JobsEnabledCallout, {
        hasHostJobs: hostJobSummaries.length > 0,
        hasK8sJobs: k8sJobSummaries.length > 0,
        jobIds: jobIds,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_public.MLJobsAwaitingNodeWarning, {
        jobIds: jobIds,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 206,
          columnNumber: 15
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 9
      }
    }, tab === 'jobs' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasJobs && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      "data-test-subj": "infraFlyoutHomeManageJobsInMlButton"
    }, manageJobsLinkProps, {
      style: {
        marginRight: 5
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 23
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Manage jobs in ML",
      id: "xpack.infra.ml.anomalyFlyout.manageJobs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 25
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.createMLJobsLabel', {
      defaultMessage: 'Create ML Jobs'
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Anomaly detection is powered by machine learning. Machine learning jobs are available for the following resource types. Enable these jobs to begin detecting anomalies in your infrastructure metrics.",
      id: "xpack.infra.ml.anomalyFlyout.createJobs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(CreateJobTab, {
      hasHostJobs: hostJobSummaries.length > 0,
      hasK8sJobs: k8sJobSummaries.length > 0,
      hasSetupCapabilities: props.hasSetupCapabilities,
      createHosts: createHosts,
      createK8s: createK8s,
      hideJobType: props.hideJobType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 15
      }
    })), tab === 'anomalies' && /*#__PURE__*/_react.default.createElement(_anomalies_table.AnomaliesTable, {
      closeFlyout: closeFlyout,
      hideSelectGroup: props.hideSelectGroup,
      onJobTypeChange: onJobTypeChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 13
      }
    })));
  }
};
exports.FlyoutHome = FlyoutHome;
const JobsEnabledCallout = props => {
  let target = '';
  if (props.hasHostJobs && props.hasK8sJobs) {
    target = `${_i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.create.hostTitle', {
      defaultMessage: 'Hosts'
    })} and ${_i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.create.k8sSuccessTitle', {
      defaultMessage: 'Kubernetes'
    })}`;
  } else if (props.hasHostJobs) {
    target = _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.create.hostSuccessTitle', {
      defaultMessage: 'Hosts'
    });
  } else if (props.hasK8sJobs) {
    target = _i18n.i18n.translate('xpack.infra.ml.anomalyFlyout.create.k8sSuccessTitle', {
      defaultMessage: 'Kubernetes'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "success",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Anomaly detection enabled for {target}",
      id: "xpack.infra.ml.anomalyFlyout.enabledCallout",
      values: {
        target
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 11
      }
    }),
    iconType: "check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 7
    }
  }));
};
const CreateJobTab = props => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "infraHostsJobCard",
    isDisabled: !props.hasSetupCapabilities,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'storage',
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 328,
        columnNumber: 19
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Hosts",
      id: "xpack.infra.ml.anomalyFlyout.create.hostTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 15
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Detect anomalies for memory usage and network traffic on hosts.",
      id: "xpack.infra.ml.anomalyFlyout.create.hostDescription",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 336,
        columnNumber: 15
      }
    }),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, props.hasHostJobs && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraCreateJobTabRecreateJobsButton",
      onClick: props.createHosts,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 344,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Recreate jobs",
      id: "xpack.infra.ml.anomalyFlyout.create.recreateButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 348,
        columnNumber: 21
      }
    })), !props.hasHostJobs && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraCreateJobTabEnableButton",
      onClick: props.createHosts,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 355,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Enable",
      id: "xpack.infra.ml.anomalyFlyout.create.createButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 359,
        columnNumber: 21
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 11
    }
  })), !props.hideJobType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "infraK8sJobCard",
    isDisabled: !props.hasSetupCapabilities,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoKubernetes",
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 374,
        columnNumber: 21
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Kubernetes Pods",
      id: "xpack.infra.ml.anomalyFlyout.create.k8sTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 376,
        columnNumber: 17
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Detect anomalies for memory usage and network traffic on Kubernetes Pods.",
      id: "xpack.infra.ml.anomalyFlyout.create.k8sDescription",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 382,
        columnNumber: 17
      }
    }),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, props.hasK8sJobs && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraCreateJobTabRecreateJobsButton",
      onClick: props.createK8s,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 390,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Recreate jobs",
      id: "xpack.infra.ml.anomalyFlyout.create.recreateButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 394,
        columnNumber: 23
      }
    })), !props.hasK8sJobs && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraCreateJobTabEnableButton",
      onClick: props.createK8s,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 401,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Enable",
      id: "xpack.infra.ml.anomalyFlyout.create.createButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 405,
        columnNumber: 23
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 13
    }
  }))));
};
const createResultsUrl = (jobIds, mode = 'absolute') => {
  const idString = jobIds.map(j => `'${j}'`).join(',');
  let path = '';
  const from = (0, _moment.default)().subtract(4, 'weeks').toISOString();
  const to = (0, _moment.default)().toISOString();
  path += `(ml:(jobIds:!(${idString}))`;
  path += `,refreshInterval:(display:Off,pause:!f,value:0),time:(from:'${from}'`;
  path += `,to:'${to}'`;
  if (mode === 'invalid') {
    path += `,mode:invalid`;
  }
  path += "))&_a=(query:(query_string:(analyze_wildcard:!t,query:'*')))";
  return path;
};
exports.createResultsUrl = createResultsUrl;