"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SourceStatusWrapper = exports.ExpressionLike = exports.ExpressionEditor = exports.Editor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _public2 = require("@kbn/logs-shared-plugin/public");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _types = require("../../../../../common/alerting/logs/log_threshold/types");
var _use_kibana = require("../../../../hooks/use_kibana");
var _group_by_expression = require("../../../common/group_by_expression/group_by_expression");
var _validation = require("../../validation");
var _criteria = require("./criteria");
var _threshold = require("./threshold");
var _type_switcher = require("./type_switcher");
var _log_view_switcher = require("./log_view_switcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/log_threshold/components/expression_editor/editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_BASE_EXPRESSION = {
  timeSize: 5,
  timeUnit: 'm'
};
const DEFAULT_FIELD = 'log.level';
const createDefaultCriterion = (availableFields, value) => availableFields.some(availableField => availableField.name === DEFAULT_FIELD) ? {
  field: DEFAULT_FIELD,
  comparator: _types.Comparator.EQ,
  value
} : {
  field: undefined,
  comparator: undefined,
  value: undefined
};
const createDefaultCountRuleParams = (availableFields, logView) => ({
  ...DEFAULT_BASE_EXPRESSION,
  logView,
  count: {
    value: 75,
    comparator: _types.Comparator.GT
  },
  criteria: [createDefaultCriterion(availableFields, 'error')]
});
const createDefaultRatioRuleParams = (availableFields, logView) => ({
  ...DEFAULT_BASE_EXPRESSION,
  logView,
  count: {
    value: 2,
    comparator: _types.Comparator.GT
  },
  criteria: [[createDefaultCriterion(availableFields, 'error')], [createDefaultCriterion(availableFields, 'warning')]]
});
const ExpressionEditor = props => {
  var _props$metadata$isInt, _props$metadata;
  const isInternal = (_props$metadata$isInt = (_props$metadata = props.metadata) === null || _props$metadata === void 0 ? void 0 : _props$metadata.isInternal) !== null && _props$metadata$isInt !== void 0 ? _props$metadata$isInt : false;
  const {
    services: {
      logsShared
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)(); // injected during alert registration
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isInternal ? /*#__PURE__*/_react.default.createElement(SourceStatusWrapper, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(Editor, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }))) : /*#__PURE__*/_react.default.createElement(_public2.LogViewProvider, {
    logViews: logsShared.logViews.client,
    initialLogViewReference: props.ruleParams.logView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(SourceStatusWrapper, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(Editor, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  })))));
};
exports.ExpressionEditor = ExpressionEditor;
const SourceStatusWrapper = ({
  children
}) => {
  const {
    load,
    isLoading,
    hasFailedLoading,
    isUninitialized
  } = (0, _public2.useLogViewContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading || isUninitialized ? /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  })) : hasFailedLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.infra.logs.alertFlyout.sourceStatusError', {
      defaultMessage: 'Sorry, there was a problem loading field information'
    }),
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraSourceStatusWrapperTryAgainButton",
    onClick: load,
    iconType: "refresh",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.infra.logs.alertFlyout.sourceStatusErrorTryAgain', {
    defaultMessage: 'Try again'
  }))) : children);
};
exports.SourceStatusWrapper = SourceStatusWrapper;
const Editor = props => {
  var _ruleParams$count, _ruleParams$count2;
  const {
    setRuleParams,
    ruleParams,
    errors
  } = props;
  const [hasSetDefaults, setHasSetDefaults] = (0, _react.useState)(false);
  const {
    logViewReference,
    resolvedLogView
  } = (0, _public2.useLogViewContext)();
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  if (logViewReference.type !== 'log-view-reference') {
    throw new Error('The Log Threshold rule type only supports persisted Log Views');
  }
  const {
    criteria: criteriaErrors,
    threshold: thresholdErrors,
    timeSizeUnit: timeSizeUnitErrors,
    timeWindowSize: timeWindowSizeErrors
  } = (0, _react.useMemo)(() => (0, _ioTsUtils.decodeOrThrow)(_validation.errorsRT)(errors), [errors]);
  const supportedFields = (0, _react.useMemo)(() => {
    if (resolvedLogView !== null && resolvedLogView !== void 0 && resolvedLogView.dataViewReference.fields) {
      return resolvedLogView.dataViewReference.fields.filter(field => {
        return (field.type === 'string' || field.type === 'number') && field.searchable;
      });
    } else {
      return [];
    }
  }, [resolvedLogView]);
  const groupByFields = (0, _react.useMemo)(() => {
    if (resolvedLogView !== null && resolvedLogView !== void 0 && resolvedLogView.dataViewReference.fields) {
      return resolvedLogView.dataViewReference.fields.filter(field => {
        return field.type === 'string' && field.aggregatable;
      });
    } else {
      return [];
    }
  }, [resolvedLogView]);
  const updateThreshold = (0, _react.useCallback)(thresholdParams => {
    const nextThresholdParams = {
      ...ruleParams.count,
      ...thresholdParams
    };
    setRuleParams('count', nextThresholdParams);
  }, [ruleParams.count, setRuleParams]);
  const updateCriteria = (0, _react.useCallback)(criteria => {
    setRuleParams('criteria', criteria);
  }, [setRuleParams]);
  const updateTimeSize = (0, _react.useCallback)(ts => {
    setRuleParams('timeSize', ts);
  }, [setRuleParams]);
  const updateTimeUnit = (0, _react.useCallback)(tu => {
    if (_types.timeUnitRT.is(tu)) {
      setRuleParams('timeUnit', tu);
    }
  }, [setRuleParams]);
  const updateGroupBy = (0, _react.useCallback)(groups => {
    setRuleParams('groupBy', groups);
  }, [setRuleParams]);
  const defaultCountAlertParams = (0, _react.useMemo)(() => createDefaultCountRuleParams(supportedFields, logViewReference), [supportedFields, logViewReference]);
  const updateType = (0, _react.useCallback)(type => {
    const defaults = type === 'count' ? defaultCountAlertParams : createDefaultRatioRuleParams(supportedFields, logViewReference);
    // Reset properties that don't make sense switching from one context to the other
    setRuleParams('count', defaults.count);
    setRuleParams('criteria', defaults.criteria);
  }, [defaultCountAlertParams, setRuleParams, supportedFields, logViewReference]);
  (0, _useMount.default)(() => {
    const newAlertParams = {
      ...defaultCountAlertParams,
      ...ruleParams
    };
    for (const [key, value] of Object.entries(newAlertParams)) {
      setRuleParams(key, value);
    }
    setHasSetDefaults(true);
  });
  const shouldShowGroupByOptimizationWarning = (0, _react.useMemo)(() => {
    const hasSetGroupBy = ruleParams.groupBy && ruleParams.groupBy.length > 0;
    return hasSetGroupBy && ruleParams.count && !(0, _types.isOptimizableGroupedThreshold)(ruleParams.count.comparator, ruleParams.count.value);
  }, [ruleParams]);

  // Wait until the alert param defaults have been set
  if (!hasSetDefaults) return null;
  const criteriaComponent = ruleParams.criteria ? /*#__PURE__*/_react.default.createElement(_criteria.Criteria, {
    fields: supportedFields,
    criteria: ruleParams.criteria,
    defaultCriterion: defaultCountAlertParams.criteria[0],
    errors: criteriaErrors,
    ruleParams: ruleParams,
    logViewReference: logViewReference,
    updateCriteria: updateCriteria,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 5
    }
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, resolvedLogView && /*#__PURE__*/_react.default.createElement(_log_view_switcher.LogViewSwitcher, {
    logView: resolvedLogView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.infra.editor.modifyLogViewSetting', {
    defaultMessage: 'To modify go to '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraEditorLinkToAdvancedSettings",
    href: http.basePath.prepend('/app/management/kibana/settings?query=Log+sources'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.infra.editor.euiLink.advancedSettingsLabel', {
    defaultMessage: 'Advanced Settings.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_type_switcher.TypeSwitcher, {
    criteria: ruleParams.criteria || [],
    updateType: updateType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 7
    }
  }), ruleParams.criteria && !(0, _types.isRatioRule)(ruleParams.criteria) && criteriaComponent, /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
    comparator: (_ruleParams$count = ruleParams.count) === null || _ruleParams$count === void 0 ? void 0 : _ruleParams$count.comparator,
    value: (_ruleParams$count2 = ruleParams.count) === null || _ruleParams$count2 === void 0 ? void 0 : _ruleParams$count2.value,
    updateThreshold: updateThreshold,
    errors: thresholdErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.ForLastExpression, {
    timeWindowSize: ruleParams.timeSize,
    timeWindowUnit: ruleParams.timeUnit,
    onChangeWindowSize: updateTimeSize,
    onChangeWindowUnit: updateTimeUnit,
    errors: {
      timeWindowSize: timeWindowSizeErrors,
      timeSizeUnit: timeSizeUnitErrors
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_group_by_expression.GroupByExpression, {
    selectedGroups: ruleParams.groupBy,
    onChange: updateGroupBy,
    fields: groupByFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 7
    }
  }), ruleParams.criteria && (0, _types.isRatioRule)(ruleParams.criteria) && criteriaComponent, shouldShowGroupByOptimizationWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.infra.logs.alertFlyout.groupByOptimizationWarning', {
    defaultMessage: 'When setting a "group by" we highly recommend using the "{comparator}" comparator for your threshold. This can lead to significant performance improvements.',
    values: {
      comparator: _types.Comparator.GT
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 7
    }
  }));
};

// required for dynamic import
// eslint-disable-next-line import/no-default-export
exports.Editor = Editor;
var _default = exports.default = ExpressionEditor; // NOTE: Temporary until EUI allow empty values in EuiExpression
// components.
const ExpressionLike = ({
  text
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "euiExpression euiExpression-isUppercase euiExpression--success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "euiExpression__description",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 7
    }
  }, text));
};
exports.ExpressionLike = ExpressionLike;