"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhoenixSpanProcessor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _openinferenceSemanticConventions = require("@arizeai/openinference-semantic-conventions");
var _api = require("@opentelemetry/api");
var _base_inference_span_processor = require("../base_inference_span_processor");
var _types = require("../types");
var _get_chat_span = require("./get_chat_span");
var _get_execute_tool_span = require("./get_execute_tool_span");
var _phoenix_otlp_exporter = require("./phoenix_otlp_exporter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Build the Phoenix URL by preserving any path prefix on the base URL and
 * appending the provided path (which may start with '/').
 */
function getPhoenixUrl(base, path) {
  const baseUrl = new URL(base);
  const baseWithTrailingSlash = baseUrl.pathname.endsWith('/') ? baseUrl.toString() : `${baseUrl.toString()}/`;
  const pathWithoutLeadingSlash = path.startsWith('/') ? path.slice(1) : path;
  return new URL(pathWithoutLeadingSlash, baseWithTrailingSlash);
}
class PhoenixSpanProcessor extends _base_inference_span_processor.BaseInferenceSpanProcessor {
  constructor(config) {
    const headers = {
      ...(config.api_key ? {
        Authorization: `Bearer ${config.api_key}`
      } : {})
    };
    const exporter = new _phoenix_otlp_exporter.PhoenixProtoExporter({
      headers,
      url: `${config.base_url}/v1/traces`
    });
    super(exporter, config.scheduled_delay);
    (0, _defineProperty2.default)(this, "getProjectId", void 0);
    this.config = config;
    const getProjectIdMemoized = (0, _lodash.memoize)(async () => {
      var _data$find, _data$;
      if (!config.public_url) {
        return undefined;
      }
      const {
        data
      } = await fetch(getPhoenixUrl(config.public_url, '/v1/projects'), {
        headers
      }).then(response => response.json());
      return config.project_name ? (_data$find = data.find(item => item.name === config.project_name)) === null || _data$find === void 0 ? void 0 : _data$find.id : (_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.id;
    });
    this.getProjectId = () => {
      return getProjectIdMemoized().catch(error => {
        var _getProjectIdMemoized, _getProjectIdMemoized2;
        _api.diag.error(`Could not get project ID from Phoenix: ${error.message}`);
        (_getProjectIdMemoized = (_getProjectIdMemoized2 = getProjectIdMemoized.cache).clear) === null || _getProjectIdMemoized === void 0 ? void 0 : _getProjectIdMemoized.call(_getProjectIdMemoized2);
        return undefined;
      });
    };
  }
  processInferenceSpan(span) {
    var _this$config$project_;
    const operationName = span.attributes[_types.GenAISemanticConventions.GenAIOperationName];
    span.resource.attributes[_openinferenceSemanticConventions.SEMRESATTRS_PROJECT_NAME] = (_this$config$project_ = this.config.project_name) !== null && _this$config$project_ !== void 0 ? _this$config$project_ : 'default';
    span.attributes[_openinferenceSemanticConventions.SemanticConventions.OPENINFERENCE_SPAN_KIND] = span.attributes[_types.ElasticGenAIAttributes.InferenceSpanKind];
    if (operationName === 'chat') {
      span = (0, _get_chat_span.getChatSpan)(span);
    } else if (operationName === 'execute_tool') {
      span = (0, _get_execute_tool_span.getExecuteToolSpan)(span);
    }
    if (!span.parentSpanContext) {
      const traceId = span.spanContext().traceId;
      void this.getProjectId().then(projectId => {
        if (!projectId || !this.config.public_url) {
          return;
        }
        const url = getPhoenixUrl(this.config.public_url, `/projects/${projectId}/traces/${traceId}?selected`);
        _api.diag.info(`View trace at ${url.toString()}`);
      });
    }
    return span;
  }
}
exports.PhoenixSpanProcessor = PhoenixSpanProcessor;