"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateToolCalls = validateToolCalls;
var _ajv = _interopRequireDefault(require("ajv"));
var _ajvFormats = _interopRequireDefault(require("ajv-formats"));
var _inferenceCommon = require("@kbn/inference-common");
var _errors = require("../../common/chat_complete/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateToolCalls({
  toolCalls,
  toolChoice,
  tools
}) {
  const validator = new _ajv.default();
  (0, _ajvFormats.default)(validator, {
    mode: 'fast'
  });
  if (toolCalls.length && toolChoice === _inferenceCommon.ToolChoiceType.none) {
    throw (0, _errors.createToolValidationError)(`tool_choice was "none" but ${toolCalls.map(toolCall => toolCall.function.name).join(', ')} was/were called`, {
      toolCalls
    });
  }
  return toolCalls.map(toolCall => {
    var _tool$schema;
    const tool = tools === null || tools === void 0 ? void 0 : tools[toolCall.function.name];
    if (!tool) {
      throw (0, _errors.createToolNotFoundError)({
        name: toolCall.function.name,
        args: toolCall.function.arguments
      });
    }
    const toolSchema = (_tool$schema = tool.schema) !== null && _tool$schema !== void 0 ? _tool$schema : {
      type: 'object',
      properties: {}
    };
    let serializedArguments;
    try {
      serializedArguments = JSON.parse(toolCall.function.arguments);
    } catch (error) {
      throw (0, _errors.createToolValidationError)(`Failed parsing arguments for ${toolCall.function.name}`, {
        name: toolCall.function.name,
        arguments: toolCall.function.arguments,
        toolCalls: [toolCall]
      });
    }
    const valid = validator.validate(toolSchema, serializedArguments);
    if (!valid) {
      throw (0, _errors.createToolValidationError)(`Tool call arguments for ${toolCall.function.name} (${toolCall.toolCallId}) were invalid`, {
        name: toolCall.function.name,
        errorsText: validator.errorsText(),
        arguments: toolCall.function.arguments,
        toolCalls
      });
    }
    return {
      toolCallId: toolCall.toolCallId,
      function: {
        name: toolCall.function.name,
        arguments: serializedArguments
      }
    };
  });
}