"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isChatCompletionChunkEvent = isChatCompletionChunkEvent;
exports.isChatCompletionEvent = isChatCompletionEvent;
exports.isChatCompletionMessageEvent = isChatCompletionMessageEvent;
exports.isChatCompletionTokenCountEvent = isChatCompletionTokenCountEvent;
exports.withoutChunkEvents = withoutChunkEvents;
exports.withoutTokenCountEvents = withoutTokenCountEvents;
var _rxjs = require("rxjs");
var _events = require("./events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Check if the provided {@link ChatCompletionEvent} is a {@link ChatCompletionChunkEvent}
 */
function isChatCompletionChunkEvent(event) {
  return event.type === _events.ChatCompletionEventType.ChatCompletionChunk;
}

/**
 * Check if the provided {@link ChatCompletionEvent} is a {@link ChatCompletionMessageEvent}
 */
function isChatCompletionMessageEvent(event) {
  return event.type === _events.ChatCompletionEventType.ChatCompletionMessage;
}

/**
 * Check if the provided {@link ChatCompletionEvent} is a {@link ChatCompletionMessageEvent}
 */
function isChatCompletionTokenCountEvent(event) {
  return event.type === _events.ChatCompletionEventType.ChatCompletionTokenCount;
}

/**
 * Check if the provided {@link InferenceTaskEvent} is a {@link ChatCompletionEvent}
 */
function isChatCompletionEvent(event) {
  return event.type === _events.ChatCompletionEventType.ChatCompletionChunk || event.type === _events.ChatCompletionEventType.ChatCompletionMessage || event.type === _events.ChatCompletionEventType.ChatCompletionTokenCount;
}

/**
 * Operator filtering out the chunk events from the provided observable.
 */
function withoutChunkEvents() {
  return (0, _rxjs.filter)(event => event.type !== _events.ChatCompletionEventType.ChatCompletionChunk);
}

/**
 * Operator filtering out the token count events from the provided observable.
 */
function withoutTokenCountEvents() {
  return (0, _rxjs.filter)(event => event.type !== _events.ChatCompletionEventType.ChatCompletionTokenCount);
}