"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultAIConnector = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _i18n = require("@kbn/i18n");
var _settings_context = require("../../contexts/settings_context");
var _constants = require("../../../common/constants");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/components/default_ai_connector/default_ai_connector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NoDefaultOption = {
  label: _i18n.i18n.translate('xpack.gen_ai_settings.settings.defaultLLm.select.option.noDefaultConnector', {
    defaultMessage: 'No default connector'
  }),
  value: _constants.NO_DEFAULT_CONNECTOR
};

// Validation function for Default AI Connector settings
const validateDefaultAIConnector = (unsavedChanges, fields, connectors) => {
  var _connectors$connector;
  const defaultLlmValue = getDefaultLlmValue(unsavedChanges, fields);
  const defaultLlmOnlyValue = getDefaultLlmOnlyValue(unsavedChanges, fields);
  const errors = [];

  // Check if selected connector exists
  const selectedConnectorExists = ((_connectors$connector = connectors.connectors) === null || _connectors$connector === void 0 ? void 0 : _connectors$connector.some(connector => connector.id === defaultLlmValue)) || defaultLlmValue === _constants.NO_DEFAULT_CONNECTOR;
  if (!selectedConnectorExists && !connectors.loading) {
    errors.push({
      message: _i18n.i18n.translate('xpack.gen_ai_settings.settings.defaultLLm.select.error.selectedDefaultLlmDoesNotExist.message', {
        defaultMessage: 'The connector previously selected does not exist anymore. Please select a different option.'
      }),
      field: _managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR
    });
  }

  // Check if "disallow all other connectors" is enabled but no default connector is selected
  if (defaultLlmOnlyValue && defaultLlmValue === _constants.NO_DEFAULT_CONNECTOR) {
    errors.push({
      message: _i18n.i18n.translate('xpack.gen_ai_settings.settings.defaultLLmOnly.error.connectorNotSelected.message', {
        defaultMessage: 'When disallowing all other connectors, a default connector must be selected.'
      }),
      field: _managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY
    });
  }
  return errors;
};
const getOptions = connectors => {
  var _connectors$connector2, _connectors$connector3, _connectors$connector4, _connectors$connector5;
  const preconfigured = (_connectors$connector2 = (_connectors$connector3 = connectors.connectors) === null || _connectors$connector3 === void 0 ? void 0 : _connectors$connector3.filter(connector => connector.isPreconfigured).map(connector => ({
    label: connector.name,
    value: connector.id
  }))) !== null && _connectors$connector2 !== void 0 ? _connectors$connector2 : [];
  const custom = (_connectors$connector4 = (_connectors$connector5 = connectors.connectors) === null || _connectors$connector5 === void 0 ? void 0 : _connectors$connector5.filter(connector => !connector.isPreconfigured).map(connector => ({
    label: connector.name,
    value: connector.id
  }))) !== null && _connectors$connector4 !== void 0 ? _connectors$connector4 : [];
  return [NoDefaultOption, {
    label: _i18n.i18n.translate('xpack.gen_ai_settings.settings.defaultLLm.select.group.preconfigured.label', {
      defaultMessage: 'Pre-configured'
    }),
    value: 'preconfigured',
    options: preconfigured
  }, {
    label: _i18n.i18n.translate('xpack.gen_ai_settings.settings.defaultLLm.select.group.custom.label', {
      defaultMessage: 'Custom connectors'
    }),
    value: 'custom',
    options: custom
  }];
};
const getOptionsByValues = (value, options) => {
  const getOptionsByValuesHelper = option => {
    if (option.options === undefined && option.value === value) {
      // If the option has no sub-options and its value is in the selected values, include it
      return [option];
    }
    if (option.options) {
      // If the option has sub-options, recursively get their options
      return option.options.flatMap(getOptionsByValuesHelper);
    }
    return [];
  };
  return options.flatMap(getOptionsByValuesHelper);
};
const DefaultAIConnector = ({
  connectors
}) => {
  var _application$capabili, _selectedOptions$;
  const options = (0, _react.useMemo)(() => getOptions(connectors), [connectors]);

  // Memoize field names to prevent recreation on every render
  const fieldNames = (0, _react.useMemo)(() => [_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR, _managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY], []);

  // Use field-specific settings context
  const {
    handleFieldChange,
    fields,
    unsavedChanges,
    setValidationErrors
  } = (0, _settings_context.useFieldSettingsContext)(fieldNames);
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    notifications,
    application
  } = services;
  const canEditAdvancedSettings = (_application$capabili = application.capabilities.advancedSettings) === null || _application$capabili === void 0 ? void 0 : _application$capabili.save;

  // Calculate and set validation errors automatically
  _react.default.useEffect(() => {
    const errors = validateDefaultAIConnector(unsavedChanges, fields, connectors);
    setValidationErrors(errors);
  }, [unsavedChanges, fields, connectors, setValidationErrors]);

  // Get current validation errors for inline display
  const validationErrors = (0, _react.useMemo)(() => validateDefaultAIConnector(unsavedChanges, fields, connectors), [unsavedChanges, fields, connectors]);
  const onChangeDefaultLlm = selectedOptions => {
    var _values$, _fields$GEN_AI_SETTIN;
    const values = selectedOptions.map(option => option.value);
    if (values.length > 1) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.defaultLlm.onChange.error.multipleSelected.title', {
          defaultMessage: 'An error occurred while changing the setting'
        }),
        text: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.defaultLlm.onChange.error.multipleSelected.text', {
          defaultMessage: 'Only one default AI connector can be selected'
        })
      });
      throw new Error('Only one default AI connector can be selected');
    }
    const value = (_values$ = values[0]) !== null && _values$ !== void 0 ? _values$ : _constants.NO_DEFAULT_CONNECTOR;
    if (value === ((_fields$GEN_AI_SETTIN = fields[_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR]) === null || _fields$GEN_AI_SETTIN === void 0 ? void 0 : _fields$GEN_AI_SETTIN.savedValue)) {
      handleFieldChange(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR);
      return;
    }
    handleFieldChange(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR, {
      type: 'string',
      unsavedValue: value
    });
  };
  const onChangeDefaultOnly = checked => {
    var _fields$GEN_AI_SETTIN2;
    if (checked === ((_fields$GEN_AI_SETTIN2 = fields[_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY]) === null || _fields$GEN_AI_SETTIN2 === void 0 ? void 0 : _fields$GEN_AI_SETTIN2.savedValue)) {
      handleFieldChange(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY);
      return;
    }
    handleFieldChange(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY, {
      type: 'boolean',
      unsavedValue: checked
    });
  };
  const defaultLlmValue = getDefaultLlmValue(unsavedChanges, fields);
  const selectedOptions = (0, _react.useMemo)(() => getOptionsByValues(defaultLlmValue, options), [defaultLlmValue, options]);
  const defaultLlmOnlyValue = getDefaultLlmOnlyValue(unsavedChanges, fields);

  // Get validation errors for display (still needed for inline validation)
  const defaultLlmErrors = validationErrors.map(error => error.message);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR,
    isInvalid: defaultLlmErrors.length > 0,
    error: defaultLlmErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "defaultAiConnectorComboBox",
    placeholder: _i18n.i18n.translate('xpack.gen_ai_settings.settings.defaultLLm.select.placeholder', {
      defaultMessage: 'Select a single option'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedOptions,
    onChange: onChangeDefaultLlm,
    isLoading: connectors.loading,
    isDisabled: !canEditAdvancedSettings,
    isInvalid: selectedOptions.length === 0 && !connectors.loading || defaultLlmOnlyValue && ((_selectedOptions$ = selectedOptions[0]) === null || _selectedOptions$ === void 0 ? void 0 : _selectedOptions$.value) === _constants.NO_DEFAULT_CONNECTOR,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "defaultAiConnectorCheckbox",
    "data-test-subj": "defaultAiConnectorCheckbox",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.gen_ai_settings.settings.defaultLlmOnly.checkbox.label",
      defaultMessage: "Disallow all other connectors",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 17
      }
    }),
    checked: defaultLlmOnlyValue,
    onChange: e => onChangeDefaultOnly(e.target.checked),
    disabled: !canEditAdvancedSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.gen_ai_settings.settings.defaultLLmOnly.checkbox.tooltip', {
      defaultMessage: 'Only the chosen default connector will be shown to users of this space.'
    }),
    position: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 13
    }
  })))));
};

/**
 * Gets current value for the default LLM connector. First checks for unsaved changes, then saved, then default.
 */
exports.DefaultAIConnector = DefaultAIConnector;
function getDefaultLlmValue(unsavedChanges, fields) {
  var _unsavedChanges$GEN_A, _fields$GEN_AI_SETTIN3, _fields$GEN_AI_SETTIN4, _ref, _ref2;
  const defaultLlmUnsavedValue = (_unsavedChanges$GEN_A = unsavedChanges[_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR]) === null || _unsavedChanges$GEN_A === void 0 ? void 0 : _unsavedChanges$GEN_A.unsavedValue;
  const defaultLlmSavedValue = (_fields$GEN_AI_SETTIN3 = fields[_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR]) === null || _fields$GEN_AI_SETTIN3 === void 0 ? void 0 : _fields$GEN_AI_SETTIN3.savedValue;
  const defaultLlmDefaultValue = (_fields$GEN_AI_SETTIN4 = fields[_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR]) === null || _fields$GEN_AI_SETTIN4 === void 0 ? void 0 : _fields$GEN_AI_SETTIN4.defaultValue;
  const defaultLlmValue = (_ref = (_ref2 = defaultLlmUnsavedValue !== null && defaultLlmUnsavedValue !== void 0 ? defaultLlmUnsavedValue : defaultLlmSavedValue) !== null && _ref2 !== void 0 ? _ref2 : defaultLlmDefaultValue) !== null && _ref !== void 0 ? _ref : _constants.NO_DEFAULT_CONNECTOR;
  return defaultLlmValue;
}

/**
 * Gets current value for the default LLM only setting. First checks for unsaved changes, then saved, then default.
 */
function getDefaultLlmOnlyValue(unsavedChanges, fields) {
  var _unsavedChanges$GEN_A2, _fields$GEN_AI_SETTIN5, _fields$GEN_AI_SETTIN6, _ref3, _ref4;
  const defaultLlmOnlyUnsavedValue = (_unsavedChanges$GEN_A2 = unsavedChanges[_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY]) === null || _unsavedChanges$GEN_A2 === void 0 ? void 0 : _unsavedChanges$GEN_A2.unsavedValue;
  const defaultLlmOnlySavedValue = (_fields$GEN_AI_SETTIN5 = fields[_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY]) === null || _fields$GEN_AI_SETTIN5 === void 0 ? void 0 : _fields$GEN_AI_SETTIN5.savedValue;
  const defaultLlmOnlyDefaultValue = (_fields$GEN_AI_SETTIN6 = fields[_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY]) === null || _fields$GEN_AI_SETTIN6 === void 0 ? void 0 : _fields$GEN_AI_SETTIN6.defaultValue;
  const defaultLlmOnlyValue = (_ref3 = (_ref4 = defaultLlmOnlyUnsavedValue !== null && defaultLlmOnlyUnsavedValue !== void 0 ? defaultLlmOnlyUnsavedValue : defaultLlmOnlySavedValue) !== null && _ref4 !== void 0 ? _ref4 : defaultLlmOnlyDefaultValue) !== null && _ref3 !== void 0 ? _ref3 : false;
  return defaultLlmOnlyValue;
}