"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepInstallPrecheck = stepInstallPrecheck;
var _ = require("../../../..");
var _default_settings = require("../../../elasticsearch/template/default_settings");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallPrecheck() {
  var _appContextService$ge, _appContextService$ge2, _appContextService$ge3;
  const isILMPoliciesDisabled = (_appContextService$ge = (_appContextService$ge2 = _.appContextService.getConfig()) === null || _appContextService$ge2 === void 0 ? void 0 : (_appContextService$ge3 = _appContextService$ge2.internal) === null || _appContextService$ge3 === void 0 ? void 0 : _appContextService$ge3.disableILMPolicies) !== null && _appContextService$ge !== void 0 ? _appContextService$ge : false;
  if (isILMPoliciesDisabled) {
    return;
  }
  await (0, _utils.withPackageSpan)('Check ILM migration status', async () => {
    const ilmMigrationStatusMap = await (0, _default_settings.getILMMigrationStatus)();
    const updatedILMMigrationStatusMap = new Map(ilmMigrationStatusMap);
    const dataStreamTypes = ['logs', 'metrics', 'synthetics'];
    const ilmPolicies = await (0, _default_settings.getILMPolicies)(dataStreamTypes);
    for (const dataStreamType of dataStreamTypes) {
      const ilmPolicy = (0, _default_settings.getILMPolicy)(dataStreamType, ilmMigrationStatusMap, ilmPolicies);
      if (ilmPolicy === `${dataStreamType}@lifecycle`) {
        updatedILMMigrationStatusMap.set(dataStreamType, 'success');
      }
    }
    await (0, _default_settings.saveILMMigrationChanges)(updatedILMMigrationStatusMap);
  });
}