"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildDefaultSettings = buildDefaultSettings;
exports.getILMMigrationStatus = getILMMigrationStatus;
exports.getILMPolicies = getILMPolicies;
exports.getILMPolicy = getILMPolicy;
exports.saveILMMigrationChanges = saveILMMigrationChanges;
var _app_context = require("../../../app_context");
var _settings = require("../../../settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getILMPolicies(dataStreamTypes) {
  var _appContextService$ge, _appContextService$ge2, _appContextService$ge3;
  const isILMPolicyDisabled = (_appContextService$ge = (_appContextService$ge2 = _app_context.appContextService.getConfig()) === null || _appContextService$ge2 === void 0 ? void 0 : (_appContextService$ge3 = _appContextService$ge2.internal) === null || _appContextService$ge3 === void 0 ? void 0 : _appContextService$ge3.disableILMPolicies) !== null && _appContextService$ge !== void 0 ? _appContextService$ge : false;
  if (isILMPolicyDisabled) {
    return new Map();
  }
  const esClient = _app_context.appContextService.getInternalUserESClient();
  const ilmPolicies = new Map();
  for (const dataStreamType of dataStreamTypes) {
    const deprecatedILMPolicyName = dataStreamType;
    const newILMPolicyName = `${dataStreamType}@lifecycle`;
    const deprecatedILMPolicyResponse = await esClient.ilm.getLifecycle({
      name: deprecatedILMPolicyName
    }, {
      ignore: [404]
    });
    const deprecatedILMPolicy = deprecatedILMPolicyResponse[deprecatedILMPolicyName];
    const newILMPolicyResponse = await esClient.ilm.getLifecycle({
      name: newILMPolicyName
    }, {
      ignore: [404]
    });
    const newILMPolicy = newILMPolicyResponse[newILMPolicyName];
    ilmPolicies.set(dataStreamType, {
      deprecatedILMPolicy,
      newILMPolicy
    });
  }
  return ilmPolicies;
}
async function saveILMMigrationChanges(updatedILMMigrationStatusMap) {
  var _appContextService$ge4, _appContextService$ge5, _appContextService$ge6, _settings$ilm_migrati;
  const isILMPolicyDisabled = (_appContextService$ge4 = (_appContextService$ge5 = _app_context.appContextService.getConfig()) === null || _appContextService$ge5 === void 0 ? void 0 : (_appContextService$ge6 = _appContextService$ge5.internal) === null || _appContextService$ge6 === void 0 ? void 0 : _appContextService$ge6.disableILMPolicies) !== null && _appContextService$ge4 !== void 0 ? _appContextService$ge4 : false;
  if (isILMPolicyDisabled) {
    return;
  }
  const soClient = _app_context.appContextService.getInternalUserSOClient();
  const settings = await (0, _settings.getSettingsOrUndefined)(soClient);
  const ilmMigrationStatus = (_settings$ilm_migrati = settings === null || settings === void 0 ? void 0 : settings.ilm_migration_status) !== null && _settings$ilm_migrati !== void 0 ? _settings$ilm_migrati : {};
  if (updatedILMMigrationStatusMap.get('logs') === 'success' && (ilmMigrationStatus === null || ilmMigrationStatus === void 0 ? void 0 : ilmMigrationStatus.logs) !== 'success' || updatedILMMigrationStatusMap.get('metrics') === 'success' && (ilmMigrationStatus === null || ilmMigrationStatus === void 0 ? void 0 : ilmMigrationStatus.metrics) !== 'success' || updatedILMMigrationStatusMap.get('synthetics') === 'success' && (ilmMigrationStatus === null || ilmMigrationStatus === void 0 ? void 0 : ilmMigrationStatus.synthetics) !== 'success') {
    var _updatedILMMigrationS, _updatedILMMigrationS2, _updatedILMMigrationS3;
    _app_context.appContextService.getLogger().info(`Saving ILM migration status changes: ${JSON.stringify(Array.from(updatedILMMigrationStatusMap.entries()))}`);
    await (0, _settings.saveSettings)(soClient, {
      ilm_migration_status: {
        logs: (_updatedILMMigrationS = updatedILMMigrationStatusMap.get('logs')) !== null && _updatedILMMigrationS !== void 0 ? _updatedILMMigrationS : ilmMigrationStatus === null || ilmMigrationStatus === void 0 ? void 0 : ilmMigrationStatus.logs,
        metrics: (_updatedILMMigrationS2 = updatedILMMigrationStatusMap.get('metrics')) !== null && _updatedILMMigrationS2 !== void 0 ? _updatedILMMigrationS2 : ilmMigrationStatus === null || ilmMigrationStatus === void 0 ? void 0 : ilmMigrationStatus.metrics,
        synthetics: (_updatedILMMigrationS3 = updatedILMMigrationStatusMap.get('synthetics')) !== null && _updatedILMMigrationS3 !== void 0 ? _updatedILMMigrationS3 : ilmMigrationStatus === null || ilmMigrationStatus === void 0 ? void 0 : ilmMigrationStatus.synthetics
      }
    });
  }
}
async function getILMMigrationStatus() {
  var _appContextService$ge7, _appContextService$ge8, _appContextService$ge9, _settings$ilm_migrati2;
  const isILMPolicyDisabled = (_appContextService$ge7 = (_appContextService$ge8 = _app_context.appContextService.getConfig()) === null || _appContextService$ge8 === void 0 ? void 0 : (_appContextService$ge9 = _appContextService$ge8.internal) === null || _appContextService$ge9 === void 0 ? void 0 : _appContextService$ge9.disableILMPolicies) !== null && _appContextService$ge7 !== void 0 ? _appContextService$ge7 : false;
  if (isILMPolicyDisabled) {
    return new Map();
  }
  const soClient = _app_context.appContextService.getInternalUserSOClient();
  const settings = await (0, _settings.getSettingsOrUndefined)(soClient);
  const ilmMigrationStatus = (_settings$ilm_migrati2 = settings === null || settings === void 0 ? void 0 : settings.ilm_migration_status) !== null && _settings$ilm_migrati2 !== void 0 ? _settings$ilm_migrati2 : {};
  const ilmMigrationStatusMap = new Map([['logs', ilmMigrationStatus === null || ilmMigrationStatus === void 0 ? void 0 : ilmMigrationStatus.logs], ['metrics', ilmMigrationStatus === null || ilmMigrationStatus === void 0 ? void 0 : ilmMigrationStatus.metrics], ['synthetics', ilmMigrationStatus === null || ilmMigrationStatus === void 0 ? void 0 : ilmMigrationStatus.synthetics]]);
  return ilmMigrationStatusMap;
}
function getILMPolicy(type, ilmMigrationStatusMap, ilmPolicies) {
  var _ilmPolicies$get, _in_use_by, _in_use_by$composable;
  const deprecatedILMPolicyName = type;
  const newILMPolicyName = `${type}@lifecycle`;
  if (ilmMigrationStatusMap.get(type) === 'success') {
    return newILMPolicyName;
  }
  const {
    deprecatedILMPolicy,
    newILMPolicy
  } = (_ilmPolicies$get = ilmPolicies.get(type)) !== null && _ilmPolicies$get !== void 0 ? _ilmPolicies$get : {};

  // deprecated and new ILM policies are not modified, mark migration as success
  if ((deprecatedILMPolicy === null || deprecatedILMPolicy === void 0 ? void 0 : deprecatedILMPolicy.version) === 1 && (newILMPolicy === null || newILMPolicy === void 0 ? void 0 : newILMPolicy.version) === 1) {
    return newILMPolicyName;
  }
  // otherwise if deprecated ILM policy does not exist, use the new ILM policy
  if (!deprecatedILMPolicy) {
    return newILMPolicyName;
  }
  // otherwise if the deprecated ILM policy is not used, use the new ILM policy
  if ((deprecatedILMPolicy === null || deprecatedILMPolicy === void 0 ? void 0 : deprecatedILMPolicy.version) > 1 && ((_in_use_by = deprecatedILMPolicy.in_use_by) === null || _in_use_by === void 0 ? void 0 : (_in_use_by$composable = _in_use_by.composable_templates) === null || _in_use_by$composable === void 0 ? void 0 : _in_use_by$composable.length) === 0) {
    return newILMPolicyName;
  }
  return deprecatedILMPolicyName;
}
function buildDefaultSettings({
  ilmPolicy,
  type,
  isOtelInputType,
  ilmMigrationStatusMap
}) {
  var _appContextService$ge10, _appContextService$ge11, _appContextService$ge12;
  const isILMPolicyDisabled = (_appContextService$ge10 = (_appContextService$ge11 = _app_context.appContextService.getConfig()) === null || _appContextService$ge11 === void 0 ? void 0 : (_appContextService$ge12 = _appContextService$ge11.internal) === null || _appContextService$ge12 === void 0 ? void 0 : _appContextService$ge12.disableILMPolicies) !== null && _appContextService$ge10 !== void 0 ? _appContextService$ge10 : false;
  if (isILMPolicyDisabled) {
    return {
      index: {}
    };
  }
  if (ilmPolicy) {
    return {
      index: {
        lifecycle: {
          name: ilmPolicy
        }
      }
    };
  }
  const defaultIlmPolicy = isOtelInputType || ilmMigrationStatusMap.get(type) === 'success' ? `${type}@lifecycle` : type;
  return {
    index: {
      lifecycle: {
        name: defaultIlmPolicy
      }
    }
  };
}