"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentPolicyWithPackagePolicies = useAgentPolicyWithPackagePolicies;
exports.useCloudSecurityIntegration = useCloudSecurityIntegration;
exports.useFetchFullPolicy = useFetchFullPolicy;
exports.useGetCreateApiKey = useGetCreateApiKey;
exports.useIsK8sPolicy = useIsK8sPolicy;
var _crypto = _interopRequireDefault(require("crypto"));
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _jsYaml = require("js-yaml");
var _hooks = require("../../hooks");
var _common = require("../../../common");
var _services = require("../cloud_security_posture/services");
var _services2 = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Packages that requires custom elastic-agent manifest
const K8S_PACKAGES = new Set([_common.FLEET_KUBERNETES_PACKAGE, _common.FLEET_CLOUD_DEFEND_PACKAGE]);
function useAgentPolicyWithPackagePolicies(policyId) {
  const [agentPolicyWithPackagePolicies, setAgentPolicy] = (0, _react.useState)(null);
  const core = (0, _hooks.useStartServices)();
  const {
    notifications
  } = core;
  (0, _react.useEffect)(() => {
    async function loadPolicy(policyIdToLoad) {
      if (!policyIdToLoad) {
        return;
      }
      try {
        const agentPolicyRequest = await (0, _hooks.sendGetOneAgentPolicy)(policyIdToLoad);
        setAgentPolicy(agentPolicyRequest.data ? agentPolicyRequest.data.item : null);
      } catch (err) {
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.loadPolicyErrorMessage', {
            defaultMessage: 'An error happened while loading the policy'
          })
        });
      }
    }
    loadPolicy(policyId);
  }, [policyId, notifications.toasts]);
  return {
    agentPolicyWithPackagePolicies
  };
}
function useIsK8sPolicy(agentPolicy) {
  const [isK8s, setIsK8s] = (0, _react.useState)('IS_LOADING');
  (0, _react.useEffect)(() => {
    async function checkifK8s() {
      if (!agentPolicy) {
        setIsK8s('IS_LOADING');
        return;
      }
      setIsK8s(agentPolicy.package_policies.some(isK8sPackage) ? 'IS_KUBERNETES' : 'IS_NOT_KUBERNETES');
    }
    checkifK8s();
  }, [agentPolicy]);
  return {
    isK8s
  };
}
function useCloudSecurityIntegration(agentPolicy) {
  var _cloudSecurityPackage, _cloudSecurityPackage2;
  const cloudSecurityPackagePolicy = (0, _react.useMemo)(() => {
    return getCloudSecurityPackagePolicyFromAgentPolicy(agentPolicy);
  }, [agentPolicy]);
  const integrationVersion = cloudSecurityPackagePolicy === null || cloudSecurityPackagePolicy === void 0 ? void 0 : (_cloudSecurityPackage = cloudSecurityPackagePolicy.package) === null || _cloudSecurityPackage === void 0 ? void 0 : _cloudSecurityPackage.version;
  const packageName = (cloudSecurityPackagePolicy === null || cloudSecurityPackagePolicy === void 0 ? void 0 : (_cloudSecurityPackage2 = cloudSecurityPackagePolicy.package) === null || _cloudSecurityPackage2 === void 0 ? void 0 : _cloudSecurityPackage2.name) === _common.FLEET_CLOUD_SECURITY_POSTURE_PACKAGE ? _common.FLEET_CLOUD_SECURITY_POSTURE_PACKAGE : _common.FLEET_CLOUD_SECURITY_ASSET_PACKAGE;

  // Fetch the package info to get the CloudFormation template URL only
  // if the package policy is a Cloud Security policy
  const {
    data: packageInfoData,
    isLoading
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(packageName, integrationVersion, {
    full: true
  }, {
    enabled: Boolean(cloudSecurityPackagePolicy)
  });
  const AWS_ACCOUNT_TYPE = 'aws.account_type';
  const AZURE_ACCOUNT_TYPE = 'azure.account_type';
  const cloudSecurityIntegration = (0, _react.useMemo)(() => {
    var _cloudSecurityPackage3, _cloudSecurityPackage4, _cloudSecurityPackage5, _cloudSecurityPackage6, _cloudSecurityPackage7, _cloudSecurityPackage8, _cloudSecurityPackage9, _cloudSecurityPackage10, _cloudSecurityPackage11, _cloudSecurityPackage12, _cloudSecurityPackage13, _cloudSecurityPackage14, _cloudSecurityPackage15, _cloudSecurityPackage16;
    if (!agentPolicy || !cloudSecurityPackagePolicy) {
      return undefined;
    }
    const integrationType = (_cloudSecurityPackage3 = cloudSecurityPackagePolicy.inputs) === null || _cloudSecurityPackage3 === void 0 ? void 0 : (_cloudSecurityPackage4 = _cloudSecurityPackage3.find(input => input.enabled)) === null || _cloudSecurityPackage4 === void 0 ? void 0 : _cloudSecurityPackage4.policy_template;
    if (!integrationType) return undefined;
    const cloudFormationTemplateFromAgentPolicy = (0, _services.getTemplateUrlFromAgentPolicy)(_services.SUPPORTED_TEMPLATES_URL_FROM_AGENT_POLICY_CONFIG.CLOUD_FORMATION, agentPolicy);
    const azureArmTemplateFromAgentPolicy = (0, _services.getTemplateUrlFromAgentPolicy)(_services.SUPPORTED_TEMPLATES_URL_FROM_AGENT_POLICY_CONFIG.ARM_TEMPLATE, agentPolicy);

    // Use the latest CloudFormation template for the current version
    // So it guarantee that the template version matches the integration version
    // when the integration is upgraded.
    // In case it can't find the template for the current version,
    // it will fallback to the one from the agent policy.
    const cloudFormationTemplateUrl = packageInfoData !== null && packageInfoData !== void 0 && packageInfoData.item ? (0, _services.getTemplateUrlFromPackageInfo)(packageInfoData.item, integrationType, _services.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS.CLOUD_FORMATION) : cloudFormationTemplateFromAgentPolicy;
    const cloudFormationAwsAccountType = cloudSecurityPackagePolicy === null || cloudSecurityPackagePolicy === void 0 ? void 0 : (_cloudSecurityPackage5 = cloudSecurityPackagePolicy.inputs) === null || _cloudSecurityPackage5 === void 0 ? void 0 : (_cloudSecurityPackage6 = _cloudSecurityPackage5.find(input => input.enabled)) === null || _cloudSecurityPackage6 === void 0 ? void 0 : (_cloudSecurityPackage7 = _cloudSecurityPackage6.streams) === null || _cloudSecurityPackage7 === void 0 ? void 0 : (_cloudSecurityPackage8 = _cloudSecurityPackage7[0]) === null || _cloudSecurityPackage8 === void 0 ? void 0 : (_cloudSecurityPackage9 = _cloudSecurityPackage8.vars) === null || _cloudSecurityPackage9 === void 0 ? void 0 : (_cloudSecurityPackage10 = _cloudSecurityPackage9[AWS_ACCOUNT_TYPE]) === null || _cloudSecurityPackage10 === void 0 ? void 0 : _cloudSecurityPackage10.value;
    const azureArmTemplateUrl = packageInfoData !== null && packageInfoData !== void 0 && packageInfoData.item ? (0, _services.getTemplateUrlFromPackageInfo)(packageInfoData.item, integrationType, _services.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS.ARM_TEMPLATE) : azureArmTemplateFromAgentPolicy;
    const azureArmTemplateAccountType = cloudSecurityPackagePolicy === null || cloudSecurityPackagePolicy === void 0 ? void 0 : (_cloudSecurityPackage11 = cloudSecurityPackagePolicy.inputs) === null || _cloudSecurityPackage11 === void 0 ? void 0 : (_cloudSecurityPackage12 = _cloudSecurityPackage11.find(input => input.enabled)) === null || _cloudSecurityPackage12 === void 0 ? void 0 : (_cloudSecurityPackage13 = _cloudSecurityPackage12.streams) === null || _cloudSecurityPackage13 === void 0 ? void 0 : (_cloudSecurityPackage14 = _cloudSecurityPackage13[0]) === null || _cloudSecurityPackage14 === void 0 ? void 0 : (_cloudSecurityPackage15 = _cloudSecurityPackage14.vars) === null || _cloudSecurityPackage15 === void 0 ? void 0 : (_cloudSecurityPackage16 = _cloudSecurityPackage15[AZURE_ACCOUNT_TYPE]) === null || _cloudSecurityPackage16 === void 0 ? void 0 : _cloudSecurityPackage16.value;
    const cloudShellUrl = (0, _services.getCloudShellUrlFromAgentPolicy)(agentPolicy);
    return {
      isLoading,
      integrationType,
      isCloudFormation: Boolean(cloudFormationTemplateFromAgentPolicy),
      cloudFormationProps: {
        awsAccountType: cloudFormationAwsAccountType,
        templateUrl: cloudFormationTemplateUrl
      },
      isAzureArmTemplate: Boolean(azureArmTemplateFromAgentPolicy),
      azureArmTemplateProps: {
        azureAccountType: azureArmTemplateAccountType,
        templateUrl: azureArmTemplateUrl
      },
      cloudShellUrl
    };
  }, [agentPolicy, packageInfoData === null || packageInfoData === void 0 ? void 0 : packageInfoData.item, isLoading, cloudSecurityPackagePolicy]);
  return {
    cloudSecurityIntegration
  };
}
const isK8sPackage = pkg => {
  var _pkg$package;
  const name = (_pkg$package = pkg.package) === null || _pkg$package === void 0 ? void 0 : _pkg$package.name;
  return K8S_PACKAGES.has(name);
};
const getCloudSecurityPackagePolicyFromAgentPolicy = agentPolicy => {
  var _agentPolicy$package_;
  return agentPolicy === null || agentPolicy === void 0 ? void 0 : (_agentPolicy$package_ = agentPolicy.package_policies) === null || _agentPolicy$package_ === void 0 ? void 0 : _agentPolicy$package_.find(input => {
    var _input$package, _input$package2;
    return ((_input$package = input.package) === null || _input$package === void 0 ? void 0 : _input$package.name) === _common.FLEET_CLOUD_SECURITY_POSTURE_PACKAGE || ((_input$package2 = input.package) === null || _input$package2 === void 0 ? void 0 : _input$package2.name) === _common.FLEET_CLOUD_SECURITY_ASSET_PACKAGE;
  });
};
function useGetCreateApiKey() {
  const core = (0, _hooks.useStartServices)();
  const [apiKey, setApiKey] = (0, _react.useState)(undefined);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onCreateApiKey = (0, _react.useCallback)(async () => {
    try {
      setIsLoading(true);
      const res = await (0, _hooks.sendCreateStandaloneAgentAPIKey)({
        name: _crypto.default.randomBytes(16).toString('hex')
      });
      const newApiKey = `${res.item.id}:${res.item.api_key}`;
      setApiKey(newApiKey);
    } catch (err) {
      core.notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.standaloneAgentPage.errorCreatingAgentAPIKey', {
          defaultMessage: 'Error creating Agent API Key'
        })
      });
    }
    setIsLoading(false);
  }, [core.notifications.toasts]);
  return {
    apiKey,
    isLoading,
    onCreateApiKey
  };
}
function useFetchFullPolicy(agentPolicy, isK8s) {
  const core = (0, _hooks.useStartServices)();
  const [yaml, setYaml] = (0, _react.useState)('');
  const [fullAgentPolicy, setFullAgentPolicy] = (0, _react.useState)();
  const {
    apiKey,
    isLoading: isCreatingApiKey,
    onCreateApiKey
  } = useGetCreateApiKey();
  (0, _react.useEffect)(() => {
    async function fetchFullPolicy() {
      try {
        if (!(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.id)) {
          return;
        }
        let query = {
          standalone: true,
          kubernetes: false
        };
        if (isK8s === 'IS_KUBERNETES') {
          query = {
            standalone: true,
            kubernetes: true
          };
        }
        const res = await (0, _hooks.sendGetOneAgentPolicyFull)(agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id, query);
        if (res.error) {
          throw res.error;
        }
        if (!res.data) {
          throw new Error('No data while fetching full agent policy');
        }
        setFullAgentPolicy(res.data.item);
      } catch (error) {
        core.notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.standaloneAgentPage.errorFetchingFullAgentPolicy', {
            defaultMessage: 'Error fetching full agent policy'
          })
        });
      }
    }
    if (isK8s === 'IS_NOT_KUBERNETES' || isK8s !== 'IS_LOADING') {
      fetchFullPolicy();
    }
  }, [core.http.basePath, agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id, core.notifications.toasts, apiKey, isK8s, agentPolicy]);
  (0, _react.useEffect)(() => {
    if (!fullAgentPolicy) {
      return;
    }
    if (isK8s === 'IS_KUBERNETES') {
      if (typeof fullAgentPolicy === 'object') {
        return;
      }
      setYaml(fullAgentPolicy);
    } else {
      if (typeof fullAgentPolicy === 'string') {
        return;
      }
      setYaml((0, _services2.fullAgentPolicyToYaml)(fullAgentPolicy, _jsYaml.dump, apiKey));
    }
  }, [apiKey, fullAgentPolicy, isK8s]);
  const downloadYaml = (0, _react.useMemo)(() => () => {
    const link = document.createElement('a');
    link.href = `data:text/x-yaml;charset=utf-8,${yaml}`;
    link.download = `elastic-agent.yml`;
    link.click();
  }, [yaml]);
  return {
    yaml,
    onCreateApiKey,
    fullAgentPolicy,
    isCreatingApiKey,
    apiKey,
    downloadYaml
  };
}