"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIntegrationButton = AddIntegrationButton;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/components/add_integration_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AddIntegrationButton(props) {
  const {
    userCanInstallPackages,
    missingSecurityConfiguration,
    packageName,
    href,
    onClick
  } = props;
  const tooltip = !userCanInstallPackages ? {
    content: missingSecurityConfiguration ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.addPackagePolicyButtonSecurityRequiredTooltip",
      defaultMessage: "To add Elastic Agent Integrations, you must have security enabled and have the All privilege for Fleet. Contact your administrator.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.addPackagePolicyButtonPrivilegesRequiredTooltip",
      defaultMessage: "Elastic Agent Integrations require the All privilege for Agent policies and All privilege for Integrations. Contact your administrator.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    })
  } : undefined;
  return /*#__PURE__*/_react.default.createElement(_components.EuiButtonWithTooltip, {
    fill: true,
    isDisabled: !userCanInstallPackages,
    iconType: "plusInCircle",
    href: href,
    onClick: e => onClick(e),
    "data-test-subj": "addIntegrationPolicyButton",
    tooltip: tooltip,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.addPackagePolicyButtonText",
    defaultMessage: "Add {packageName}",
    values: {
      packageName
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
}