"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentStatusBar = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _agent_status = require("../../services/agent_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/status_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiColorPaletteDisplay = (0, _styledComponents.default)(_eui.EuiColorPaletteDisplay)`
  &.ingest-agent-status-bar {
    border: none;
    border-radius: 0;
    &:after {
      border: none;
    }
  }
`;
const AgentStatusBar = ({
  agentStatus
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const palette = (0, _react.useMemo)(() => {
    return _agent_status.AGENT_STATUSES.reduce((acc, status) => {
      const previousStop = acc.length > 0 ? acc[acc.length - 1].stop : 0;
      acc.push({
        stop: previousStop + (agentStatus[status] || 0),
        color: (0, _agent_status.getColorForAgentStatus)(status, euiTheme)
      });
      return acc;
    }, []);
  }, [agentStatus, euiTheme]);
  const hasNoAgent = palette[palette.length - 1].stop === 0;
  if (hasNoAgent) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(StyledEuiColorPaletteDisplay, {
    "data-test-subj": "agentStatusBar",
    className: "ingest-agent-status-bar",
    size: "s",
    palette: palette,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  });
};
exports.AgentStatusBar = AgentStatusBar;