"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDetailsIntegration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../../../hooks");
var _components = require("../../../../../components");
var _agent_details_integration_inputs = require("./agent_details_integration_inputs");
var _input_status_utils = require("./input_status_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/components/agent_details/agent_details_integration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .euiAccordion__button {
    width: 90%;
  }

  .euiAccordion__triggerWrapper {
    padding-left: ${props => props.theme.eui.euiSizeM};
  }

  &.euiAccordion-isOpen {
    .euiAccordion__childWrapper {
      padding: ${props => props.theme.eui.euiSizeM};
      padding-top: 0px;
    }
  }

  .ingest-integration-title-button {
    padding: ${props => props.theme.eui.euiSizeS};
  }

  .euiTableRow:last-child .euiTableRowCell {
    border-bottom: none;
  }

  .euiIEFlexWrapFix {
    min-width: 0;
  }

  .euiAccordion__buttonContent {
    width: 100%;
  }
`;
const CollapsablePanel = ({
  id,
  title,
  children,
  'data-test-subj': dataTestSubj
}) => {
  const arrowProps = (0, _react.useMemo)(() => {
    if (dataTestSubj) {
      return {
        'data-test-subj': `${dataTestSubj}-openCloseToggle`
      };
    }
    return undefined;
  }, [dataTestSubj]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: id,
    arrowDisplay: "left",
    buttonClassName: "ingest-integration-title-button",
    buttonContent: title,
    arrowProps: arrowProps,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, children));
};
const AgentDetailsIntegration = exports.AgentDetailsIntegration = /*#__PURE__*/(0, _react.memo)(({
  agent,
  agentPolicy,
  packagePolicy,
  linkToLogs = true,
  'data-test-subj': dataTestSubj
}) => {
  var _packagePolicy$packag, _packagePolicy$packag2, _packagePolicy$packag3, _packagePolicy$packag4;
  const {
    getHref
  } = (0, _hooks.useLink)();
  const theme = (0, _eui.useEuiTheme)();
  const [isAttentionBadgeNeededForPolicyResponse, setIsAttentionBadgeNeededForPolicyResponse] = (0, _react.useState)(false);
  const policyResponseExtensionView = (0, _hooks.useUIExtension)((_packagePolicy$packag = (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name) !== null && _packagePolicy$packag !== void 0 ? _packagePolicy$packag : '', 'package-policy-response');
  const policyResponseExtensionViewWrapper = (0, _react.useMemo)(() => {
    return policyResponseExtensionView && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(policyResponseExtensionView.Component, {
      agent: agent,
      onShowNeedsAttentionBadge: setIsAttentionBadgeNeededForPolicyResponse,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    }));
  }, [agent, policyResponseExtensionView]);
  const packageErrors = (0, _react.useMemo)(() => {
    if (!agent.components) {
      return [];
    }
    return (0, _input_status_utils.getInputUnitsByPackage)(agent.components, packagePolicy).filter(u => u.status === 'DEGRADED' || u.status === 'FAILED');
  }, [agent.components, packagePolicy]);
  const showNeedsAttentionBadge = isAttentionBadgeNeededForPolicyResponse || !!packageErrors.length;
  const genericErrorsListExtensionView = (0, _hooks.useUIExtension)((_packagePolicy$packag3 = (_packagePolicy$packag4 = packagePolicy.package) === null || _packagePolicy$packag4 === void 0 ? void 0 : _packagePolicy$packag4.name) !== null && _packagePolicy$packag3 !== void 0 ? _packagePolicy$packag3 : '', 'package-generic-errors-list');
  const genericErrorsListExtensionViewWrapper = (0, _react.useMemo)(() => {
    return genericErrorsListExtensionView && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(genericErrorsListExtensionView.Component, {
      packageErrors: packageErrors,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 13
      }
    }));
  }, [packageErrors, genericErrorsListExtensionView]);
  return /*#__PURE__*/_react.default.createElement(CollapsablePanel, {
    id: packagePolicy.id,
    "data-test-subj": dataTestSubj,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 17
      }
    }, packagePolicy.package ? /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
      packageName: packagePolicy.package.name,
      version: packagePolicy.package.version,
      size: "l",
      tryApi: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 21
      }
    }) : /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
      size: "l",
      packageName: "default",
      version: "0",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      className: "eui-textTruncate",
      "data-test-subj": "agentPolicyDetailsLink",
      href: getHref('edit_integration', {
        policyId: agentPolicy.id,
        packagePolicyId: packagePolicy.id
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 19
      }
    }, packagePolicy.name)), showNeedsAttentionBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: theme.euiTheme.colors.danger,
      iconType: "warning",
      iconSide: "left",
      "data-test-subj": dataTestSubj ? `${dataTestSubj}-needsAttention` : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetailsIntegrations.needsAttention.label",
      defaultMessage: "Needs attention",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 23
      }
    })))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_details_integration_inputs.AgentDetailsIntegrationInputs, {
    agent: agent,
    packagePolicy: packagePolicy,
    linkToLogs: linkToLogs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }), policyResponseExtensionViewWrapper, genericErrorsListExtensionViewWrapper, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  }));
});