"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.agentPolicyFormValidation = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_validation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const agentPolicyFormValidation = (agentPolicy, options) => {
  var _agentPolicy$name, _agentPolicy$monitori, _agentPolicy$monitori3, _agentPolicy$monitori4, _agentPolicy$monitori5, _agentPolicy$monitori6, _agentPolicy$monitori7, _agentPolicy$monitori8, _agentPolicy$monitori9, _agentPolicy$monitori10;
  const errors = {};
  const namespaceValidation = (0, _services.isValidNamespace)(agentPolicy.namespace || '', false, options === null || options === void 0 ? void 0 : options.allowedNamespacePrefixes);
  if (!((_agentPolicy$name = agentPolicy.name) !== null && _agentPolicy$name !== void 0 && _agentPolicy$name.trim())) {
    errors.name = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.nameRequiredErrorMessage",
      defaultMessage: "Agent policy name is required",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    })];
  }
  if (!namespaceValidation.valid && namespaceValidation.error) {
    errors.namespace = [namespaceValidation.error];
  }
  if (agentPolicy.unenroll_timeout && agentPolicy.unenroll_timeout < 0) {
    errors.unenroll_timeout = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.unenrollTimeoutMinValueErrorMessage",
      defaultMessage: "Unenroll timeout must be greater than zero.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    })];
  }
  if (agentPolicy.inactivity_timeout && agentPolicy.inactivity_timeout < 0) {
    errors.inactivity_timeout = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutMinValueErrorMessage",
      defaultMessage: "Inactivity timeout must be greater than zero.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    })];
  }
  if ((_agentPolicy$monitori = agentPolicy.monitoring_http) !== null && _agentPolicy$monitori !== void 0 && _agentPolicy$monitori.enabled) {
    var _agentPolicy$monitori2;
    if (!((_agentPolicy$monitori2 = agentPolicy.monitoring_http.host) !== null && _agentPolicy$monitori2 !== void 0 && _agentPolicy$monitori2.trim())) {
      errors['monitoring_http.host'] = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.monitoringHttpHostRequiredErrorMessage",
        defaultMessage: "Host is required for HTTP monitoring",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 9
        }
      })];
    }
    if (!agentPolicy.monitoring_http.port || agentPolicy.monitoring_http.port !== undefined && agentPolicy.monitoring_http.port <= 0) {
      errors['monitoring_http.port'] = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.monitoringHttpPortRequiredErrorMessage",
        defaultMessage: "Port is required for HTTP monitoring",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 9
        }
      })];
    }
  }
  if (((_agentPolicy$monitori3 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori3 === void 0 ? void 0 : (_agentPolicy$monitori4 = _agentPolicy$monitori3.limit) === null || _agentPolicy$monitori4 === void 0 ? void 0 : _agentPolicy$monitori4.burst) !== undefined && ((_agentPolicy$monitori5 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori5 === void 0 ? void 0 : (_agentPolicy$monitori6 = _agentPolicy$monitori5.limit) === null || _agentPolicy$monitori6 === void 0 ? void 0 : _agentPolicy$monitori6.burst) <= 0) {
    errors['monitoring_diagnostics.limit.burst'] = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsLimitBurstMinValueErrorMessage",
      defaultMessage: "Burst must be an integer greater than zero",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    })];
  }
  if (((_agentPolicy$monitori7 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori7 === void 0 ? void 0 : (_agentPolicy$monitori8 = _agentPolicy$monitori7.uploader) === null || _agentPolicy$monitori8 === void 0 ? void 0 : _agentPolicy$monitori8.max_retries) !== undefined && ((_agentPolicy$monitori9 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori9 === void 0 ? void 0 : (_agentPolicy$monitori10 = _agentPolicy$monitori9.uploader) === null || _agentPolicy$monitori10 === void 0 ? void 0 : _agentPolicy$monitori10.max_retries) <= 0) {
    errors['monitoring_diagnostics.uploader.max_retries'] = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsLimitBurstMinValueErrorMessage",
      defaultMessage: "Max retries must be an integer greater than zero",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    })];
  }
  return errors;
};
exports.agentPolicyFormValidation = agentPolicyFormValidation;