"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileFlyout = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _sharedUxFileImage = require("@kbn/shared-ux-file-image");
var _react = _interopRequireDefault(require("react"));
var _i18n_texts = require("../i18n_texts");
var _context = require("../context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/files_management/public/components/file_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const FileFlyout = ({
  onClose,
  file
}) => {
  var _file$extension$toUpp, _file$extension, _file$mimeType, _file$mimeType2, _file$alt;
  const {
    filesClient
  } = (0, _context.useFilesManagementContext)();
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'fileFlyout'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    size: "m",
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, file.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    listItems: [{
      title: _i18n_texts.i18nTexts.filesFlyoutStatus,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: file.status === 'READY' ? 'success' : file.status === 'AWAITING_UPLOAD' || file.status === 'UPLOADING' ? 'primary' : 'warning',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 21
        }
      }, _i18n_texts.i18nTexts.filesStatus[file.status])
    }, {
      title: _i18n_texts.i18nTexts.filesFlyoutSize,
      description: (0, _numeral.default)(file.size).format('0[.]0 b')
    }, {
      title: _i18n_texts.i18nTexts.filesFlyoutExtension,
      description: (_file$extension$toUpp = (_file$extension = file.extension) === null || _file$extension === void 0 ? void 0 : _file$extension.toUpperCase()) !== null && _file$extension$toUpp !== void 0 ? _file$extension$toUpp : ''
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    listItems: [{
      title: _i18n_texts.i18nTexts.filesFlyoutMimeType,
      description: (_file$mimeType = file.mimeType) !== null && _file$mimeType !== void 0 ? _file$mimeType : ''
    }, {
      title: _i18n_texts.i18nTexts.filesFlyoutCreated,
      description: file.created
    }, {
      title: _i18n_texts.i18nTexts.filesFlyoutUpdated,
      description: file.updated
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }))), ((_file$mimeType2 = file.mimeType) === null || _file$mimeType2 === void 0 ? void 0 : _file$mimeType2.startsWith('image/')) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, _i18n_texts.i18nTexts.filesFlyoutPreview)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxFileImage.FileImage, {
    size: "xl",
    alt: (_file$alt = file.alt) !== null && _file$alt !== void 0 ? _file$alt : '',
    src: filesClient.getDownloadHref(file),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: filesClient.getDownloadHref(file),
    iconType: "download",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, _i18n_texts.i18nTexts.filesFlyoutDownload))));
};
exports.FileFlyout = FileFlyout;