"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSeriesButton = AddSeriesButton;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _series_editor = require("../series_editor/series_editor");
var _use_series_storage = require("../hooks/use_series_storage");
var _use_app_data_view = require("../hooks/use_app_data_view");
var _constants = require("../configurations/constants");
var _exploratory_view_config = require("../contexts/exploratory_view_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/views/add_series_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AddSeriesButton() {
  const [editorItems, setEditorItems] = (0, _react.useState)([]);
  const addSeriesButtonRef = (0, _react.useRef)(null);
  const {
    getSeries,
    allSeries,
    setSeries,
    reportType
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    loading,
    dataViews
  } = (0, _use_app_data_view.useAppDataViewContext)();
  const {
    reportConfigMap
  } = (0, _exploratory_view_config.useExploratoryView)();
  (0, _react.useEffect)(() => {
    setEditorItems((0, _series_editor.getSeriesToEdit)({
      allSeries,
      dataViews,
      reportType,
      reportConfigMap
    }));
  }, [allSeries, getSeries, dataViews, loading, reportConfigMap, reportType]);
  const addSeries = () => {
    const prevSeries = allSeries === null || allSeries === void 0 ? void 0 : allSeries[0];
    const name = `${_use_series_storage.NEW_SERIES_KEY}-${editorItems.length + 1}`;
    const nextSeries = {
      name
    };
    if (addSeriesButtonRef !== null && addSeriesButtonRef !== void 0 && addSeriesButtonRef.current) {
      addSeriesButtonRef.current.blur();
    }
    const nextSeriesId = allSeries.length;
    if (reportType === 'data-distribution') {
      setSeries(nextSeriesId, {
        ...nextSeries,
        time: (prevSeries === null || prevSeries === void 0 ? void 0 : prevSeries.time) || _constants.DEFAULT_TIME
      });
    } else {
      setSeries(nextSeriesId, prevSeries ? nextSeries : {
        ...nextSeries,
        time: _constants.DEFAULT_TIME
      });
    }
  };
  const isAddDisabled = !reportType || (reportType === _constants.ReportTypes.CORE_WEB_VITAL || reportType === _constants.ReportTypes.DEVICE_DISTRIBUTION || reportType === _constants.ReportTypes.SINGLE_METRIC) && allSeries.length > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !reportType ? _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.addSeries.selectReportType', {
      defaultMessage: 'Please select report type before you can add series.'
    }) : isAddDisabled ? _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.addSeries.limitation', {
      defaultMessage: 'You can only add one series of this report type.'
    }) : '',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yAddSeriesButtonAddSeriesButton",
    onClick: () => addSeries(),
    isDisabled: isAddDisabled,
    iconType: "plusInCircle",
    size: "s",
    buttonRef: addSeriesButtonRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.addSeries', {
    defaultMessage: 'Add series'
  })));
}