"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMEFIELD_ROUTE = exports.SOURCES_TYPES = exports.SOURCES_AUTOCOMPLETE_ROUTE = exports.REGISTRY_EXTENSIONS_ROUTE = exports.LOOKUP_INDEX_UPDATE_ROUTE = exports.LOOKUP_INDEX_RECREATE_ROUTE = exports.LOOKUP_INDEX_PRIVILEGES_ROUTE = exports.LOOKUP_INDEX_CREATE_ROUTE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const REGISTRY_EXTENSIONS_ROUTE = exports.REGISTRY_EXTENSIONS_ROUTE = '/internal/esql_registry/extensions/';
const SOURCES_AUTOCOMPLETE_ROUTE = exports.SOURCES_AUTOCOMPLETE_ROUTE = '/internal/esql/autocomplete/sources/';
const TIMEFIELD_ROUTE = exports.TIMEFIELD_ROUTE = '/internal/esql/get_timefield/';
const LOOKUP_INDEX_ROUTE = '/internal/esql/lookup_index';
const LOOKUP_INDEX_CREATE_ROUTE = exports.LOOKUP_INDEX_CREATE_ROUTE = `${LOOKUP_INDEX_ROUTE}/create`;
const LOOKUP_INDEX_UPDATE_ROUTE = exports.LOOKUP_INDEX_UPDATE_ROUTE = `${LOOKUP_INDEX_ROUTE}/update`;
const LOOKUP_INDEX_RECREATE_ROUTE = exports.LOOKUP_INDEX_RECREATE_ROUTE = `${LOOKUP_INDEX_ROUTE}/recreate`;
const LOOKUP_INDEX_PRIVILEGES_ROUTE = exports.LOOKUP_INDEX_PRIVILEGES_ROUTE = `${LOOKUP_INDEX_ROUTE}/privileges`;
let SOURCES_TYPES = exports.SOURCES_TYPES = /*#__PURE__*/function (SOURCES_TYPES) {
  SOURCES_TYPES["INDEX"] = "Index";
  SOURCES_TYPES["TIMESERIES"] = "Timeseries";
  SOURCES_TYPES["INTEGRATION"] = "Integration";
  SOURCES_TYPES["ALIAS"] = "Alias";
  SOURCES_TYPES["DATA_STREAM"] = "Data Stream";
  SOURCES_TYPES["LOOKUP"] = "Lookup";
  return SOURCES_TYPES;
}({});