"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dispatchPartialOperators = dispatchPartialOperators;
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const PARTIAL_OPERATOR_HANDLERS = {
  in: _handlers.handleInOperator,
  'not in': _handlers.handleInOperator,
  like: _handlers.handleLikeOperator,
  rlike: _handlers.handleLikeOperator,
  'not like': _handlers.handleLikeOperator,
  'not rlike': _handlers.handleLikeOperator,
  'is null': _handlers.handleNullCheckOperator,
  'is not null': _handlers.handleNullCheckOperator
};

/**
 * Dispatches partial operator detection to appropriate handler.
 */
async function dispatchPartialOperators(operatorName, detection, context) {
  const handler = PARTIAL_OPERATOR_HANDLERS[operatorName];
  return handler ? handler(detection, context) : null;
}