"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeSeriesAggFunctionDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../commands_registry/types");
var _types2 = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * __AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.__
 *
 * @note This file is generated by the `generate_function_definitions.ts`
 * script. Do not edit it manually.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const absentOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'absent_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.absent_over_time', {
    defaultMessage: 'Calculates the absence of a field in the output result over time range.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geohash',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geohex',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geotile',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| WHERE cluster == "prod" AND pod == "two"\n| STATS events_received = MAX(ABSENT_OVER_TIME(events_received)) BY pod, time_bucket = TBUCKET(2 minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const avgOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'avg_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.avg_over_time', {
    defaultMessage: 'Calculates the average over time of a numeric field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'aggregate_metric_double',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS max_cost=MAX(AVG_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const countDistinctOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'count_distinct_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.count_distinct_over_time', {
    defaultMessage: 'Calculates the count of distinct values over time for a field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }, {
      name: 'precision',
      type: 'integer',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }, {
      name: 'precision',
      type: 'long',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }, {
      name: 'precision',
      type: 'unsigned_long',
      optional: true
    }],
    returnType: 'long'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS distincts=COUNT_DISTINCT(COUNT_DISTINCT_OVER_TIME(network.cost)),\n        distincts_imprecise=COUNT_DISTINCT(COUNT_DISTINCT_OVER_TIME(network.cost, 100))\n  BY cluster, time_bucket = TBUCKET(1minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const countOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'count_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.count_over_time', {
    defaultMessage: 'Calculates the count over time value of a field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'geohash',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'geohex',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'geotile',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'long'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS count=COUNT(COUNT_OVER_TIME(network.cost))\n  BY cluster, time_bucket = BUCKET(@timestamp,1minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const deltaDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'delta',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.delta', {
    defaultMessage: 'Calculates the absolute change of a gauge field in a time window.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| WHERE pod == "one"\n| STATS tx = SUM(DELTA(network.bytes_in)) BY cluster, time_bucket = TBUCKET(10minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const derivDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'deriv',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.deriv', {
    defaultMessage: 'Calculates the derivative over time of a numeric field using linear regression.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| WHERE pod == "three"\n| STATS max_deriv = MAX(DERIV(network.cost)) BY time_bucket = BUCKET(@timestamp,5minute), pod']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const firstOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'first_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.first_over_time', {
    defaultMessage: 'Calculates the earliest value of a field, where recency determined by the `@timestamp` field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'counter_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'counter_long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS max_cost=MAX(FIRST_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const ideltaDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'idelta',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.idelta', {
    defaultMessage: 'Calculates the idelta of a gauge. idelta is the absolute change between the last two data points (it ignores all but the last two data points in each time period). This function is very similar to delta, but is more responsive to recent changes.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS events = SUM(IDELTA(events_received)) by pod, time_bucket = TBUCKET(10minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const increaseDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'increase',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.increase', {
    defaultMessage: 'Calculates the absolute increase of a counter field in a time window.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'counter_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| WHERE pod == "one"\n| STATS increase_bytes_in = SUM(INCREASE(network.total_bytes_in)) BY cluster, time_bucket = TBUCKET(10minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const irateDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'irate',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.irate', {
    defaultMessage: 'Calculates the irate of a counter field. irate is the per-second rate of increase between the last two data points (it ignores all but the last two data points in each time period). This function is very similar to rate, but is more responsive to recent changes in the rate of increase.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'counter_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s | WHERE pod == "one"\n| STATS irate_bytes_in = SUM(IRATE(network.total_bytes_in)) BY cluster, time_bucket = TBUCKET(10minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const lastOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'last_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.last_over_time', {
    defaultMessage: 'Calculates the latest value of a field, where recency determined by the `@timestamp` field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'counter_double',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_integer',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'counter_long',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'long'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS max_cost=MAX(LAST_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const maxOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'max_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.max_over_time', {
    defaultMessage: 'Calculates the maximum over time value of a field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS cost=SUM(MAX_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const minOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'min_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.min_over_time', {
    defaultMessage: 'Calculates the minimum over time value of a field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'integer'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'ip'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'unsigned_long'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'version'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS cost=SUM(MIN_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const percentileOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'percentile_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.percentile_over_time', {
    defaultMessage: 'Calculates the percentile over time of a numeric field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'percentile',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'percentile',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }, {
      name: 'percentile',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'percentile',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'percentile',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }, {
      name: 'percentile',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'percentile',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'percentile',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }, {
      name: 'percentile',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS p95_cost=MAX(PERCENTILE_OVER_TIME(network.cost, 95)), p99_cost=MAX(PERCENTILE_OVER_TIME(network.cost, 99)) BY cluster, time_bucket = TBUCKET(1minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const presentOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'present_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.present_over_time', {
    defaultMessage: 'Calculates the presence of a field in the output result over time range.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'boolean',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'cartesian_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geo_point',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geo_shape',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geohash',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geohex',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'geotile',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'ip',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'unsigned_long',
      optional: false
    }],
    returnType: 'boolean'
  }, {
    params: [{
      name: 'field',
      type: 'version',
      optional: false
    }],
    returnType: 'boolean'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| WHERE cluster == "prod" AND pod == "two"\n| STATS events_received = MAX(PRESENT_OVER_TIME(events_received)) BY pod, time_bucket = TBUCKET(2 minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const rateDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'rate',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.rate', {
    defaultMessage: 'Calculates the per-second average rate of increase of a counter. Rate calculations account for breaks in monotonicity, such as counter resets when a service restarts, and extrapolate values within each bucketed time interval. Rate is the most appropriate aggregate function for counters. It is only allowed in a STATS command under a `TS` source command, to be properly applied per time series.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'counter_double',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_integer',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'counter_long',
      optional: false
    }, {
      name: 'window',
      type: 'time_duration',
      optional: true
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS max_rate=MAX(RATE(network.total_bytes_in)) BY time_bucket = TBUCKET(5minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const stddevOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'stddev_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.stddev_over_time', {
    defaultMessage: 'Calculates the population standard deviation over time of a numeric field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS max_stddev_cost=MAX(STDDEV_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const sumOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'sum_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.sum_over_time', {
    defaultMessage: 'Calculates the sum over time value of a field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'aggregate_metric_double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }],
    returnType: 'long'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }],
    returnType: 'long'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS sum_cost=SUM(SUM_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const varianceOverTimeDefinition = {
  type: _types2.FunctionDefinitionTypes.TIME_SERIES_AGG,
  name: 'variance_over_time',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.variance_over_time', {
    defaultMessage: 'Calculates the population variance over time of a numeric field.'
  }),
  preview: true,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'number',
      type: 'double',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'integer',
      optional: false
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'number',
      type: 'long',
      optional: false
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS_TIMESERIES],
  examples: ['TS k8s\n| STATS avg_var_cost=AVG(VARIANCE_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)']
};
const timeSeriesAggFunctionDefinitions = exports.timeSeriesAggFunctionDefinitions = [absentOverTimeDefinition, avgOverTimeDefinition, countDistinctOverTimeDefinition, countOverTimeDefinition, deltaDefinition, derivDefinition, firstOverTimeDefinition, ideltaDefinition, increaseDefinition, irateDefinition, lastOverTimeDefinition, maxOverTimeDefinition, minOverTimeDefinition, percentileOverTimeDefinition, presentOverTimeDefinition, rateDefinition, stddevOverTimeDefinition, sumOverTimeDefinition, varianceOverTimeDefinition];