"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QUERY_TEXT_SNIPPET = exports.QUERY_TEXT = void 0;
exports.autocomplete = autocomplete;
exports.buildNextActions = buildNextActions;
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _types = require("../../types");
var _utils = require("./utils");
var _complete_items = require("../../complete_items");
var _utils2 = require("../../../definitions/utils");
var _literals = require("../../../definitions/utils/literals");
var _map_expression = require("../../../definitions/utils/autocomplete/map_expression");
var _expressions = require("../../../definitions/utils/expressions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const QUERY_TEXT = exports.QUERY_TEXT = 'Your search query';
const QUERY_TEXT_SNIPPET = exports.QUERY_TEXT_SNIPPET = `"$\{0:${QUERY_TEXT}}"`;
const FIELD_LIST_TYPES = ['keyword', 'text', 'boolean', 'integer', 'double', 'long'];
async function autocomplete(query, command, callbacks, context, cursorPosition = query.length) {
  const rerankCommand = command;
  const innerText = query.substring(0, cursorPosition);
  if (!(callbacks !== null && callbacks !== void 0 && callbacks.getByType) || (0, _helpers.withinQuotes)(innerText)) {
    return [];
  }
  const {
    position,
    context: positionContext
  } = (0, _utils.getPosition)(innerText, command, cursorPosition);
  switch (position) {
    case _utils.CaretPosition.RERANK_KEYWORD:
      {
        var _callbacks$getSuggest;
        const targetField = (0, _complete_items.getNewUserDefinedColumnSuggestion)(((_callbacks$getSuggest = callbacks.getSuggestedUserDefinedColumnName) === null || _callbacks$getSuggest === void 0 ? void 0 : _callbacks$getSuggest.call(callbacks)) || '');
        return [targetField, {
          ...(0, _literals.buildConstantsDefinitions)([QUERY_TEXT_SNIPPET], '', '1')[0],
          label: QUERY_TEXT,
          asSnippet: true
        }];
      }
    case _utils.CaretPosition.RERANK_AFTER_TARGET_FIELD:
      {
        return [_complete_items.assignCompletionItem];
      }
    case _utils.CaretPosition.RERANK_AFTER_TARGET_ASSIGNMENT:
      {
        return [{
          ...(0, _literals.buildConstantsDefinitions)([QUERY_TEXT_SNIPPET], '', '1')[0],
          label: QUERY_TEXT,
          asSnippet: true
        }];
      }
    case _utils.CaretPosition.ON_KEYWORD:
      {
        return [_complete_items.onCompleteItem];
      }
    case _utils.CaretPosition.ON_WITHIN_FIELD_LIST:
      {
        return handleOnFieldList({
          innerText,
          callbacks,
          context,
          rerankCommand
        });
      }
    case _utils.CaretPosition.ON_KEEP_SUGGESTIONS_AFTER_TRAILING_SPACE:
      {
        var _rerankCommand$fields, _context$columns;
        const lastOnField = (_rerankCommand$fields = rerankCommand.fields) === null || _rerankCommand$fields === void 0 ? void 0 : _rerankCommand$fields[rerankCommand.fields.length - 1];
        const isAssignmentContext = !!(lastOnField && !(context !== null && context !== void 0 && (_context$columns = context.columns) !== null && _context$columns !== void 0 && _context$columns.has(lastOnField.name)));
        // ON col0␣ → '=' suggestion using lastField from the ON clause
        if (isAssignmentContext) {
          return [_complete_items.assignCompletionItem];
        }
        return buildNextActions();
      }
    case _utils.CaretPosition.ON_EXPRESSION:
      {
        return handleOnExpression({
          query,
          command,
          cursorPosition,
          callbacks,
          context,
          expressionRoot: positionContext === null || positionContext === void 0 ? void 0 : positionContext.expressionRoot,
          insideFunction: positionContext === null || positionContext === void 0 ? void 0 : positionContext.insideFunction
        });
      }
    case _utils.CaretPosition.AFTER_WITH_KEYWORD:
      return [_complete_items.withMapCompleteItem];
    case _utils.CaretPosition.WITHIN_MAP_EXPRESSION:
      {
        const endpoints = context === null || context === void 0 ? void 0 : context.inferenceEndpoints;
        const availableParameters = {
          inference_id: {
            type: 'string',
            suggestions: (endpoints === null || endpoints === void 0 ? void 0 : endpoints.map(_helpers.createInferenceEndpointToCompletionItem)) || []
          }
        };
        return (0, _map_expression.getCommandMapExpressionSuggestions)(innerText, availableParameters);
      }
    case _utils.CaretPosition.AFTER_COMMAND:
      {
        return [_complete_items.pipeCompleteItem];
      }
    default:
      {
        return [];
      }
  }
}

// ============================================================================
// Suggestion Handlers
// ============================================================================

async function handleOnFieldList({
  innerText,
  callbacks,
  context
}) {
  var _await$callbacks$getB, _callbacks$getByType;
  const fieldSuggestions = (_await$callbacks$getB = await ((_callbacks$getByType = callbacks.getByType) === null || _callbacks$getByType === void 0 ? void 0 : _callbacks$getByType.call(callbacks, FIELD_LIST_TYPES))) !== null && _await$callbacks$getB !== void 0 ? _await$callbacks$getB : [];
  const suggestions = await (0, _helpers.handleFragment)(innerText, fragment => (0, _helpers.columnExists)(fragment, context),
  // incomplete: get available fields suggestions
  (_, rangeToReplace) => {
    var _callbacks$getSuggest2;
    const customFieldSuggestion = (0, _complete_items.getNewUserDefinedColumnSuggestion)(((_callbacks$getSuggest2 = callbacks.getSuggestedUserDefinedColumnName) === null || _callbacks$getSuggest2 === void 0 ? void 0 : _callbacks$getSuggest2.call(callbacks)) || '');
    return [customFieldSuggestion, ...fieldSuggestions].map(suggestion => {
      return (0, _helpers.withAutoSuggest)({
        ...suggestion,
        rangeToReplace
      });
    });
  },
  // complete: get next actions suggestions for completed field
  (fragment, rangeToReplace) => {
    const results = buildNextActions({
      withSpaces: true
    });
    return results.map(suggestion => ({
      ...suggestion,
      filterText: fragment,
      text: fragment + suggestion.text,
      rangeToReplace
    }));
  });
  return suggestions;
}
async function handleOnExpression({
  query,
  command,
  cursorPosition,
  callbacks,
  context,
  expressionRoot,
  insideFunction
}) {
  const innerText = query.substring(0, cursorPosition);
  const suggestions = await (0, _utils2.suggestForExpression)({
    query,
    expressionRoot,
    command,
    cursorPosition,
    location: _types.Location.RERANK,
    context,
    callbacks,
    options: {
      preferredExpressionType: 'boolean'
    }
  });
  if (expressionRoot) {
    const expressionType = (0, _expressions.getExpressionType)(expressionRoot, context === null || context === void 0 ? void 0 : context.columns);
    if (expressionType === 'boolean' && (0, _expressions.isExpressionComplete)(expressionType, innerText) && !insideFunction) {
      suggestions.push(...buildNextActions());
    }
  }
  return suggestions;
}
function buildNextActions(options) {
  const {
    withSpaces = false
  } = options || {};
  const items = [];
  items.push({
    ..._complete_items.withCompleteItem,
    text: withSpaces ? ' ' + _complete_items.withCompleteItem.text + ' ' : _complete_items.withCompleteItem.text,
    sortText: '01'
  });
  items.push((0, _helpers.withAutoSuggest)({
    ..._complete_items.commaCompleteItem,
    text: _complete_items.commaCompleteItem.text + ' ',
    sortText: '02'
  }));
  items.push({
    ..._complete_items.pipeCompleteItem,
    text: withSpaces ? ' ' + _complete_items.pipeCompleteItem.text : _complete_items.pipeCompleteItem.text,
    sortText: '03'
  });
  return items;
}