"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _complete_items = require("../../complete_items");
var _shared = require("../../../definitions/utils/shared");
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition = query.length) {
  const forkCommand = command;
  const innerText = query.substring(0, cursorPosition);
  if (/FORK\s+$/i.test(innerText)) {
    return [newBranchSuggestion];
  }
  const activeBranch = getActiveBranch(forkCommand);
  const withinActiveBranch = activeBranch && activeBranch.location.min <= innerText.length && activeBranch.location.max >= innerText.length;
  if (!withinActiveBranch && /\)\s+$/i.test(innerText)) {
    const suggestions = [newBranchSuggestion];
    if (forkCommand.args.length > 1) {
      suggestions.push(_complete_items.pipeCompleteItem);
    }
    return suggestions;
  }

  // within a branch
  if ((activeBranch === null || activeBranch === void 0 ? void 0 : activeBranch.commands.length) === 0 || (0, _shared.pipePrecedesCurrentWord)(innerText)) {
    const forkCommands = _.esqlCommandRegistry.getProcessingCommandNames().filter(cmd => cmd !== 'fork');
    return (0, _complete_items.getCommandAutocompleteDefinitions)(forkCommands);
  }
  const subCommand = activeBranch === null || activeBranch === void 0 ? void 0 : activeBranch.commands[activeBranch.commands.length - 1];
  if (!subCommand) {
    return [];
  }
  const subCommandMethods = _.esqlCommandRegistry.getCommandMethods(subCommand.name);
  return (subCommandMethods === null || subCommandMethods === void 0 ? void 0 : subCommandMethods.autocomplete(innerText, subCommand, callbacks, context, cursorPosition)) || [];
}
const newBranchSuggestion = (0, _helpers.withAutoSuggest)({
  kind: 'Issue',
  label: _i18n.i18n.translate('kbn-esql-ast.esql.suggestions.newBranchLabel', {
    defaultMessage: 'New branch'
  }),
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.suggestions.newBranchDetail', {
    defaultMessage: 'Add a new branch to the fork'
  }),
  text: '($0)',
  asSnippet: true
});
const getActiveBranch = command => {
  const finalBranch = command.args[command.args.length - 1];
  if (!finalBranch) {
    return;
  }
  return finalBranch.child;
};