"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _complete_items = require("../../complete_items");
var _literals = require("../../../definitions/utils/literals");
var _types = require("../../../definitions/types");
var _ast = require("../../../definitions/utils/ast");
var _parser = require("../../../parser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const appendSeparatorCompletionItem = (0, _helpers.withAutoSuggest)({
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.appendSeparatorDoc', {
    defaultMessage: 'The character(s) that separate the appended fields. Default to empty string ("").'
  }),
  kind: 'Reference',
  label: 'APPEND_SEPARATOR',
  sortText: '1',
  text: 'APPEND_SEPARATOR = '
});
async function autocomplete(query, command, callbacks, context, cursorPosition = query.length) {
  var _await$callbacks$getB, _callbacks$getByType;
  const innerText = query.substring(0, cursorPosition);
  const commandArgs = command.args.filter(arg => !Array.isArray(arg) && arg.type !== 'unknown');

  // If cursor is inside a string literal, don't suggest anything
  const correctedQuery = (0, _ast.correctQuerySyntax)(innerText);
  const {
    root
  } = _parser.Parser.parse(correctedQuery, {
    withFormatting: true
  });
  const {
    node
  } = (0, _ast.findAstPosition)(root.commands, innerText.length);
  if ((node === null || node === void 0 ? void 0 : node.type) === 'literal' && node.literalType === 'keyword') {
    return [];
  }

  // DISSECT field/
  if (commandArgs.length === 1 && /\s$/.test(innerText)) {
    return (0, _literals.buildConstantsDefinitions)(['"%{firstWord}"'], _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.aPatternString', {
      defaultMessage: 'A pattern string'
    }), undefined, {
      advanceCursorAndOpenSuggestions: true
    });
  }
  // DISSECT field pattern /
  else if (commandArgs.length === 2) {
    return [(0, _helpers.withAutoSuggest)(_complete_items.pipeCompleteItem), appendSeparatorCompletionItem];
  }
  // DISSECT field APPEND_SEPARATOR = /
  else if (/append_separator\s*=\s*$/i.test(innerText)) {
    return [_complete_items.colonCompleteItem, _complete_items.semiColonCompleteItem];
  }
  // DISSECT field APPEND_SEPARATOR = ":" /
  else if (commandArgs.some(arg => !Array.isArray(arg) && arg.type === 'option')) {
    return [(0, _helpers.withAutoSuggest)(_complete_items.pipeCompleteItem)];
  }

  // DISSECT /
  const fieldSuggestions = (_await$callbacks$getB = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getByType = callbacks.getByType) === null || _callbacks$getByType === void 0 ? void 0 : _callbacks$getByType.call(callbacks, _types.ESQL_STRING_TYPES))) !== null && _await$callbacks$getB !== void 0 ? _await$callbacks$getB : [];
  return fieldSuggestions.map(sug => {
    const withSpace = {
      ...sug,
      text: `${sug.text} `
    };
    return (0, _helpers.withAutoSuggest)(withSpace);
  });
}