"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeRangeSchema = exports.relativeTimeRangeSchema = exports.absoluteTimeRangeSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const absoluteTimeRangeMode = _configSchema.schema.literal('absolute');
const relativeTimeRangeMode = _configSchema.schema.literal('relative');
const timeRangeSchema = exports.timeRangeSchema = _configSchema.schema.object({
  from: _configSchema.schema.string(),
  to: _configSchema.schema.string(),
  mode: _configSchema.schema.maybe(_configSchema.schema.oneOf([absoluteTimeRangeMode, relativeTimeRangeMode]))
}, {
  meta: {
    id: 'kbn-es-query-server-timeRangeSchema'
  }
});
const absoluteTimeRangeSchema = exports.absoluteTimeRangeSchema = timeRangeSchema.extends({
  mode: absoluteTimeRangeMode
}, {
  meta: {
    id: 'kbn-es-query-server-absoluteTimeRangeSchema'
  }
});
const relativeTimeRangeSchema = exports.relativeTimeRangeSchema = timeRangeSchema.extends({
  mode: relativeTimeRangeMode
}, {
  meta: {
    id: 'kbn-es-query-server-relativeTimeRangeSchema'
  }
});