"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMLInferencePipelineButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana_logic = require("../../../../../shared/kibana/kibana_logic");
var _index_view_logic = require("../../index_view_logic");
var _pipelines_logic = require("../pipelines_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_inference/add_ml_inference_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AddMLInferencePipelineButton = ({
  onClick
}) => {
  var _capabilities$ml$canG, _capabilities$ml;
  const {
    capabilities
  } = (0, _kea.useValues)(_kibana_logic.KibanaLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    canUseMlInferencePipeline,
    hasIndexIngestionPipeline
  } = (0, _kea.useValues)(_pipelines_logic.PipelinesLogic);
  const hasMLPermissions = (_capabilities$ml$canG = capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$ml = capabilities.ml) === null || _capabilities$ml === void 0 ? void 0 : _capabilities$ml.canGetTrainedModels) !== null && _capabilities$ml$canG !== void 0 ? _capabilities$ml$canG : false;
  if (!hasMLPermissions) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInference.addButton.mlPermissions.disabledTooltip', {
        defaultMessage: 'You do not have permission to use Machine Learning on this cluster.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(AddButton, {
      ingestionMethod: ingestionMethod,
      disabled: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }));
  }
  if (!hasIndexIngestionPipeline) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInference.addButton.defaultIngestPipeline.disabledTooltip', {
        defaultMessage: 'You cannot add machine learning inference pipeline processors to the default ingest pipeline. You must first copy and customize the default ingest pipeline to add machine learning inference pipeline processors.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(AddButton, {
      ingestionMethod: ingestionMethod,
      disabled: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }));
  }
  if (!canUseMlInferencePipeline) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInference.addButton.mlInferenceDisabled.disabledTooltip', {
        defaultMessage: 'You must enable ML Inference Pipelines on the Ingest Pipeline to add ML Inference Pipeline Processors.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(AddButton, {
      ingestionMethod: ingestionMethod,
      disabled: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(AddButton, {
    ingestionMethod: ingestionMethod,
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 10
    }
  });
};
exports.AddMLInferencePipelineButton = AddMLInferencePipelineButton;
const AddButton = ({
  disabled,
  ingestionMethod,
  onClick
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  fullWidth: true,
  "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-addInferencePipeline`,
  color: disabled ? undefined : 'primary',
  disabled: disabled,
  iconType: disabled ? 'lock' : 'plusInCircle',
  onClick: onClick,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 3
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInference.addButtonLabel', {
  defaultMessage: 'Add Inference Pipeline'
}));