"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddablePublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _register_triggers = require("./ui_actions/register_triggers");
var _state_transfer = require("./state_transfer");
var _kibana_services = require("./kibana_services");
var _react_embeddable_system = require("./react_embeddable_system");
var _registry = require("./add_from_library/registry");
var _registry2 = require("../common/enhancements/registry");
var _transforms_registry = require("./transforms_registry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class EmbeddablePublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "stateTransferService", {});
    (0, _defineProperty2.default)(this, "appList", void 0);
    (0, _defineProperty2.default)(this, "appListSubscription", void 0);
    (0, _defineProperty2.default)(this, "enhancementsRegistry", new _registry2.EnhancementsRegistry());
  }
  setup(core, {
    uiActions
  }) {
    (0, _register_triggers.registerTriggers)(uiActions);
    return {
      registerReactEmbeddableFactory: _react_embeddable_system.registerReactEmbeddableFactory,
      registerAddFromLibraryType: _registry.registerAddFromLibraryType,
      registerLegacyURLTransform: _transforms_registry.registerLegacyURLTransform,
      registerEnhancement: this.enhancementsRegistry.registerEnhancement,
      transformEnhancementsIn: this.enhancementsRegistry.transformIn,
      transformEnhancementsOut: this.enhancementsRegistry.transformOut
    };
  }
  start(core, deps) {
    this.appListSubscription = core.application.applications$.subscribe(appList => {
      this.appList = appList;
    });
    this.stateTransferService = new _state_transfer.EmbeddableStateTransfer(core.application.navigateToApp, core.application.currentAppId$, this.appList);
    const embeddableStart = {
      getAddFromLibraryComponent: async () => {
        const {
          AddFromLibraryFlyout
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_from_library/add_from_library_flyout')));
        return AddFromLibraryFlyout;
      },
      getStateTransfer: storage => storage ? new _state_transfer.EmbeddableStateTransfer(core.application.navigateToApp, core.application.currentAppId$, this.appList, storage) : this.stateTransferService,
      hasLegacyURLTransform: _transforms_registry.hasLegacyURLTransform,
      getLegacyURLTransform: _transforms_registry.getLegacyURLTransform,
      getEnhancement: this.enhancementsRegistry.getEnhancement
    };
    (0, _kibana_services.setKibanaServices)(core, embeddableStart, deps);
    return embeddableStart;
  }
  stop() {
    if (this.appListSubscription) {
      this.appListSubscription.unsubscribe();
    }
  }
}
exports.EmbeddablePublicPlugin = EmbeddablePublicPlugin;