"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddAlertsTableAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationUtil = require("@kbn/presentation-util");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _constants = require("../constants");
var _translations = require("../translations");
var _get_internal_rule_types_with_cache = require("../utils/get_internal_rule_types_with_cache");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/embeddable_alerts_table/public/actions/add_alerts_table_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const checkRuleTypesPermissions = async http => {
  try {
    const ruleTypes = await (0, _get_internal_rule_types_with_cache.getInternalRuleTypesWithCache)(http);
    // If the user can access at least one rule type (with any authorizedConsumer, in any app) then
    // they can create alerts visualizations
    return Boolean(ruleTypes.length);
  } catch (error) {
    return false;
  }
};
const getAddAlertsTableAction = coreServices => {
  const {
    http
  } = coreServices;
  return {
    id: _constants.ADD_ALERTS_TABLE_ACTION_ID,
    grouping: [_public.ADD_PANEL_VISUALIZATION_GROUP],
    getIconType: () => 'bell',
    isCompatible: async ({
      embeddable
    }) => {
      const hasAccessToAnyRuleTypes = await checkRuleTypesPermissions(http);
      return (0, _presentationContainers.apiIsPresentationContainer)(embeddable) && hasAccessToAnyRuleTypes;
    },
    execute: async ({
      embeddable
    }) => {
      if (!(0, _presentationContainers.apiIsPresentationContainer)(embeddable)) throw new _public2.IncompatibleActionError();
      (0, _presentationUtil.openLazyFlyout)({
        core: coreServices,
        parentApi: embeddable,
        loadContent: async ({
          closeFlyout,
          ariaLabelledBy
        }) => {
          const {
            ConfigEditor
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/config_editor')));
          return /*#__PURE__*/_react.default.createElement(ConfigEditor, {
            coreServices: coreServices,
            closeFlyout: closeFlyout,
            ariaLabelledBy: ariaLabelledBy,
            onSave: tableConfig => {
              embeddable.addNewPanel({
                panelType: _constants.EMBEDDABLE_ALERTS_TABLE_ID,
                serializedState: {
                  rawState: {
                    tableConfig
                  }
                }
              }, true);
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 51,
              columnNumber: 13
            }
          });
        }
      });
    },
    getDisplayName: () => _translations.ADD_ALERTS_TABLE_ACTION_LABEL
  };
};
exports.getAddAlertsTableAction = getAddAlertsTableAction;