"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enrichPolicyResponseFailureEvents = enrichPolicyResponseFailureEvents;
var _pMap = _interopRequireDefault(require("p-map"));
var _constants = require("../../../../../../../../../routes/knowledge_base/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const splitKey = ':::';
function getUniqueEventKey(event, index) {
  // example "configure_malware:::Disabled due to potential system deadlock. Failed to enable malware protection:::Linux"
  return `${event['actions.name'][index]}${splitKey}${event['actions.message'][index]}${splitKey}${event['host.os.name'][0]}`;
}
function getUniqueEventKeys(events) {
  return events.flatMap(event => event['actions.name'].map((_, i) => getUniqueEventKey(event, i)));
}
async function enrichPolicyResponseFailureEvents(events, kbDataClient) {
  if (!kbDataClient) {
    return events;
  }
  const uniqueEventKeys = getUniqueEventKeys(events);
  const messageToKBMap = {};
  await (0, _pMap.default)(uniqueEventKeys, async eventKey => {
    const [name, message, os] = eventKey.split(splitKey);
    const kbContext = await kbDataClient.getKnowledgeBaseDocumentEntries({
      query: `How to fix action.name:${name} action.message:${message} on ${os}?`,
      kbResource: _constants.DEFEND_INSIGHTS_POLICY_RESPONSE_FAILURE,
      filter: {
        bool: {
          must: [{
            match_phrase: {
              text: name
            }
          }, {
            match: {
              text: message
            }
          }, {
            match_phrase: {
              text: os
            }
          }]
        }
      }
    });
    messageToKBMap[eventKey] = kbContext.map(entry => entry.pageContent).join('\n===\n');
  }, {
    concurrency: 10
  });
  return events.map(event => ({
    ...event,
    'actions.context': event['actions.message'].map((_, i) => {
      var _messageToKBMap$getUn;
      return (_messageToKBMap$getUn = messageToKBMap[getUniqueEventKey(event, i)]) !== null && _messageToKBMap$getUn !== void 0 ? _messageToKBMap$getUn : '';
    })
  }));
}