"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/kibana-utils-plugin/common");
var _discoverUtils = require("@kbn/discover-utils");
var _common2 = require("../common");
var _capabilities_provider = require("./capabilities_provider");
var _embeddable = require("./embeddable");
var _locator = require("./locator");
var _sample_data = require("./sample_data");
var _ui_settings = require("./ui_settings");
var _app_locator_get_location = require("../common/app_locator_get_location");
var _constants = require("../common/constants");
var _embeddable2 = require("../common/embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DiscoverServerPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = initializerContext.config.get();
  }
  setup(core, plugins) {
    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    core.uiSettings.register((0, _ui_settings.getUiSettings)(core.docLinks, this.config.enableUiSettingsValidations));
    if (plugins.home) {
      (0, _sample_data.registerSampleData)(plugins.home.sampleData);
    }
    if (plugins.share) {
      plugins.share.url.locators.create({
        id: _common2.DISCOVER_APP_LOCATOR,
        getLocation: params => {
          return (0, _app_locator_get_location.appLocatorGetLocationCommon)({
            useHash: false,
            setStateToKbnUrl: _common.setStateToKbnUrl
          }, params);
        }
      });
    }
    plugins.embeddable.registerEmbeddableFactory((0, _embeddable.createSearchEmbeddableFactory)());
    plugins.embeddable.registerTransforms(_discoverUtils.SEARCH_EMBEDDABLE_TYPE, (0, _embeddable2.getSearchEmbeddableTransforms)(plugins.embeddable.transformEnhancementsIn, plugins.embeddable.transformEnhancementsOut));
    core.pricing.registerProductFeatures([{
      id: _constants.TRACES_PRODUCT_FEATURE_ID,
      description: 'APM traces in Discover',
      products: [{
        name: 'observability',
        tier: 'complete'
      }]
    }, {
      id: _constants.METRICS_EXPERIENCE_PRODUCT_FEATURE_ID,
      description: 'Metrics experience in Discover',
      products: [{
        name: 'observability',
        tier: 'complete'
      }, {
        name: 'security',
        tier: 'complete'
      }]
    }]);
    return {};
  }
  start(core, deps) {
    return {
      locator: (0, _locator.initializeLocatorServices)(core, deps)
    };
  }
  stop() {}
}
exports.DiscoverServerPlugin = DiscoverServerPlugin;