"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceProfileSection = DataSourceProfileSection;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _profile_section = require("./profile_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/inspector/profiles_inspector_view/data_source_profile_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function DataSourceProfileSection({
  dataSourceContext
}) {
  return /*#__PURE__*/_react.default.createElement(_profile_section.ProfileSection, {
    title: _i18n.i18n.translate('discover.inspector.profilesInspectorView.dataSourceProfileTitle', {
      defaultMessage: 'Data source profile'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: _i18n.i18n.translate('discover.inspector.profilesInspectorView.dataSourceProfileIdTitle', {
        defaultMessage: 'Profile ID'
      }),
      description: dataSourceContext.profileId
    }, {
      title: _i18n.i18n.translate('discover.inspector.profilesInspectorView.dataSourceCategoryTitle', {
        defaultMessage: 'Category'
      }),
      description: dataSourceContext.category
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }));
}