"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviewData = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _unifiedTabs = require("@kbn/unified-tabs");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _redux = require("../../state_management/redux");
var _types = require("../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const usePreviewData = runtimeStateManager => {
  const allTabs = (0, _redux.useInternalStateSelector)(_redux.selectAllTabs);
  const savedDataViews = (0, _redux.useInternalStateSelector)(state => state.savedDataViews);
  const previewDataMap$ = (0, _react.useMemo)(() => (0, _rxjs.combineLatest)(allTabs.reduce((acc, tabState) => {
    const tabId = tabState.id;
    return {
      ...acc,
      [tabId]: getPreviewDataObservable(runtimeStateManager, tabState, savedDataViews)
    };
  }, {})), [allTabs, runtimeStateManager, savedDataViews]);
  const previewDataMap = (0, _useObservable.default)(previewDataMap$);
  const getPreviewData = (0, _react.useCallback)(item => {
    var _previewDataMap$item$;
    return (_previewDataMap$item$ = previewDataMap === null || previewDataMap === void 0 ? void 0 : previewDataMap[item.id]) !== null && _previewDataMap$item$ !== void 0 ? _previewDataMap$item$ : {
      status: _unifiedTabs.TabStatus.SUCCESS,
      query: DEFAULT_PREVIEW_QUERY
    };
  }, [previewDataMap]);
  return {
    getPreviewData
  };
};
exports.usePreviewData = usePreviewData;
const getPreviewStatus = fetchStatus => {
  switch (fetchStatus) {
    case _types.FetchStatus.UNINITIALIZED:
    case _types.FetchStatus.COMPLETE:
      return _unifiedTabs.TabStatus.SUCCESS;
    case _types.FetchStatus.ERROR:
      return _unifiedTabs.TabStatus.ERROR;
    default:
      return _unifiedTabs.TabStatus.RUNNING;
  }
};
const DEFAULT_PREVIEW_QUERY = {
  language: 'kuery',
  query: _i18n.i18n.translate('discover.tabsView.defaultQuery', {
    defaultMessage: '(Empty query)'
  })
};
const getPreviewQuery = (query, dataViewName) => {
  if (!query) {
    return DEFAULT_PREVIEW_QUERY;
  }
  if ((0, _esQuery.isOfAggregateQueryType)(query)) {
    return {
      ...query,
      esql: query.esql.trim() || DEFAULT_PREVIEW_QUERY.query
    };
  }
  const trimmedQuery = typeof query.query === 'string' ? query.query.trim() : query.query;
  return {
    ...query,
    query: trimmedQuery || (dataViewName ? '' : DEFAULT_PREVIEW_QUERY.query)
  };
};
const getDataViewNameFromInitialInternalState = (initialInternalState, savedDataViews) => {
  if (!(initialInternalState !== null && initialInternalState !== void 0 && initialInternalState.serializedSearchSource)) {
    return undefined;
  }
  const index = initialInternalState.serializedSearchSource.index;
  if (typeof index === 'string') {
    const matchedDataView = savedDataViews.find(dv => dv.id === index);
    return (matchedDataView === null || matchedDataView === void 0 ? void 0 : matchedDataView.name) || (matchedDataView === null || matchedDataView === void 0 ? void 0 : matchedDataView.title);
  }
  if (index !== null && index !== void 0 && index.name) {
    return index.name;
  }
  return undefined;
};
const getPreviewTitle = (query, dataViewName) => {
  if ((0, _esQuery.isOfAggregateQueryType)(query)) {
    return undefined;
  }
  return dataViewName ? _i18n.i18n.translate('discover.tabsView.tabPreviewDataViewTitle', {
    defaultMessage: 'Data view: {dataViewName}',
    values: {
      dataViewName
    }
  }) : undefined;
};
const getPreviewDataObservable = (runtimeStateManager, tabState, savedDataViews) => {
  return (0, _redux.selectTabRuntimeState)(runtimeStateManager, tabState.id).stateContainer$.pipe((0, _rxjs.switchMap)(tabStateContainer => {
    if (!tabStateContainer) {
      const derivedDataViewName = getDataViewNameFromInitialInternalState(tabState.initialInternalState, savedDataViews);
      return (0, _rxjs.of)({
        status: _unifiedTabs.TabStatus.DEFAULT,
        query: getPreviewQuery(tabState.appState.query, derivedDataViewName),
        title: getPreviewTitle(tabState.appState.query, derivedDataViewName)
      });
    }
    return (0, _rxjs.combineLatest)([tabStateContainer.dataState.data$.main$, tabStateContainer.savedSearchState.getCurrent$()]).pipe((0, _rxjs.map)(([{
      fetchStatus
    }, {
      searchSource
    }]) => {
      var _searchSource$getFiel;
      return {
        fetchStatus,
        dataViewName: searchSource === null || searchSource === void 0 ? void 0 : (_searchSource$getFiel = searchSource.getField('index')) === null || _searchSource$getFiel === void 0 ? void 0 : _searchSource$getFiel.name
      };
    }), (0, _rxjs.distinctUntilChanged)((prev, curr) => (0, _lodash.isEqual)(prev, curr)), (0, _rxjs.map)(({
      fetchStatus,
      dataViewName
    }) => {
      var _tabState$initialInte;
      let derivedDataViewName = dataViewName;
      if (!derivedDataViewName && (_tabState$initialInte = tabState.initialInternalState) !== null && _tabState$initialInte !== void 0 && _tabState$initialInte.serializedSearchSource) {
        derivedDataViewName = getDataViewNameFromInitialInternalState(tabState.initialInternalState, savedDataViews);
      }
      return {
        status: getPreviewStatus(fetchStatus),
        query: getPreviewQuery(tabState.appState.query, derivedDataViewName),
        title: getPreviewTitle(tabState.appState.query, derivedDataViewName)
      };
    }));
  }));
};